#!/bin/sh

# this bootstraps the python dependency
# after running once and getting a new shell, you can use
#    ./scripts/deploy.py -i XXX.json
################################################################
## Change version 3.5 to 3.6
################################################################
## cp /opt/tandbergtv/cms/prepack/prepackVersion.dat /opt/tandbergtv/cms/prepack/prepackVersion.dat.bkp
## echo "3.6" > /opt/tandbergtv/cms/prepack/prepackVersion.dat

################################################################
## Get CMS version
################################################################
version=`sudo rpm -qi watchpoint-cms  | sudo grep Version | sudo awk '{print $3}'`
if [ -z "$version" ]
then
version=`conary q | sudo grep watchpoint-cms | sudo awk '{print $1}' | sudo cut -d '=' -f2`
fi

majorVersion=${version:0:3}

isCMS4_0=false
if [ "$majorVersion" != "3.1" ] && [ "$majorVersion" != "3.0" ]
then
   isCMS4_0=true
   sudo echo "CMS version is $majorVersion"
else
   sudo echo "CMS version is $majorVersion"
fi

################################################################
## Set LOG Environment
################################################################
if [ "$isCMS4_0" == true ]; then
   sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c  'echo export LOG=/opt/tandbergtv/log/jboss.log >> /etc/bashrc'
else
   sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c  'echo export LOG=/opt/tandbergtv/cms/log/jboss.log >> /etc/bashrc'
fi

PRE_CONFIGURED_FILE=$1

cd pysetup
sh ./pysetup.sh $isCMS4_0
source /etc/bashrc
cd ..

sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c  'echo export LOG=/opt/tandbergtv/cms/log/jboss.log >> /etc/bashrc'

inputParams=($@)
preFillPassword=""
paramsToPython=""

function extractPasswordParam() {
   for i in "${!inputParams[@]}"
   do
       if [[ ${inputParams[$i]} == "-w" ]]; then
            pwdIdx=$((i+1))
            preFillPassword=${inputParams[pwdIdx]}
            break
       fi
   done
}

extractPasswordParam

if [ ! -z $preFillPassword ]; then
   paramsToPython=$(echo ${inputParams[@]} | sed 's/-w//' | sed "s/${preFillPassword}//")
else
   paramsToPython=$(echo ${inputParams[@]})
fi

source ./pre-process.sh $majorVersion "patches_sysInfo.json" $preFillPassword

PRE_CONFIGURED_FILE=$1

if [ -z "$PRE_CONFIGURED_FILE" ]
then
        sudo echo "No pre-configured selection file passed in.  User will be prompt to select components directly"
        sudo python ./scripts/install.pyc -i patches_sysInfo.json -m PATCH -u $currentUser -w $password $paramsToPython
else
        sudo python ./scripts/install.pyc -i patches_sysInfo.json -m PATCH -p $PRE_CONFIGURED_FILE -u $currentUser -w $password $paramsToPython
fi

cd pysetup
sh ./pyunstall.sh $isCMS4_0
