#!/bin/sh

################################################################
## Get CMS version
################################################################
version=`sudo rpm -qi watchpoint-cms  | sudo grep Version | sudo awk '{print $3}'`
if [ -z "$version" ]
then
version=`conary q | sudo grep watchpoint-cms | sudo awk '{print $1}' | sudo cut -d '=' -f2`
fi

majorVersion=${version:0:3}

isCMS4_0=false
if [ "$majorVersion" != "3.1" ] && [ "$majorVersion" != "3.0" ]
then
   isCMS4_0=true
   sudo echo "CMS version is $majorVersion"
else
   sudo echo "CMS version is $majorVersion"
fi

################################################################
## Set LOG Environment 
################################################################
if [ "$isCMS4_0" == true ]; then
   sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c  "echo export LOG=/opt/tandbergtv/log/jboss.log >> /etc/bashrc"
else
   sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c  "echo export LOG=/opt/tandbergtv/cms/log/jboss.log >> /etc/bashrc"
fi

PRE_CONFIGURED_FILE=$1

cd pysetup
sh ./pysetup.sh $isCMS4_0
cd ..
source /etc/bashrc
sudo python ./scripts/rollback.pyc -i rollback_sysInfo.json

cd pysetup
sh ./pyunstall.sh $isCMS4_0