/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.prepack.license;

import com.ericsson.cms.prepack.license.LicenseType;
import com.ericsson.cms.prepack.license.exception.LicenseInvalidException;
import com.ericsson.cms.prepack.license.model.License;
import com.ericsson.cms.prepack.license.utils.FingerprintUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;

public class LicenseValidator {
    private static final String X509_CERT_TYPE = "X.509";
    private static final String FINGERPRINT_FILE_LOCATION = "/var/lib/nobody/.cmsconfig";
    private static final Set<String> AVAILABLE_FINGERPRINTS = new HashSet<String>();
    private String rootCertDev;
    private String rootCertPro;

    public LicenseValidator(String rootCertDev, String rootCertPro) {
        this.rootCertDev = rootCertDev;
        this.rootCertPro = rootCertPro;
    }

    public void validate(License lic) throws LicenseInvalidException {
        if (!this.isSignatureValid(lic)) {
            throw new LicenseInvalidException("License signature validation failed!");
        }
        if (!this.isCertificateChainValid(lic)) {
            throw new LicenseInvalidException("License certificate chainis validation failed!");
        }
        if (!this.isFingerprintValid(lic)) {
            throw new LicenseInvalidException("License fingerprint validation failed!");
        }
    }

    private boolean isFingerprintValid(License lic) throws LicenseInvalidException {
        File file = new File(FINGERPRINT_FILE_LOCATION);
        if (file.exists()) {
            UUID uuid = FingerprintUtil.getPrint(file);
            String print = uuid.toString().replaceAll("-", "");
            return print.equals(lic.getFingerprint());
        }
        return AVAILABLE_FINGERPRINTS.contains(lic.getFingerprint());
    }

    private boolean isCertificateChainValid(License lic) {
        try {
            X509Certificate rootCert = this.buildRootCertificate(lic.getLicenseType());
            X509Certificate caCert = this.buildCertificate(lic.getCertificatechain().getCacert());
            X509Certificate prodCert = this.buildCertificate(lic.getCertificatechain().getProdcert());
            rootCert.verify(rootCert.getPublicKey());
            caCert.verify(rootCert.getPublicKey());
            prodCert.verify(caCert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSignatureValid(License lic) {
        try {
            X509Certificate prodCert = this.buildCertificate(lic.getCertificatechain().getProdcert());
            String algorithm = prodCert.getSigAlgName();
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(prodCert.getPublicKey());
            byte[] xmlBodyArr = this.stripWhitespace(lic.getBodyContent());
            signature.update(xmlBodyArr);
            return signature.verify(DatatypeConverter.parseBase64Binary((String)lic.getPkiSignature().getValue()));
        }
        catch (Exception e) {
            return false;
        }
    }

    private X509Certificate buildCertificate(String certStr) throws CertificateException {
        return (X509Certificate)CertificateFactory.getInstance(X509_CERT_TYPE).generateCertificate(new ByteArrayInputStream(certStr.getBytes()));
    }

    private X509Certificate buildRootCertificate(LicenseType licType) throws CertificateException {
        if (licType == LicenseType.LAB || licType == LicenseType.DEV) {
            return this.buildCertificate(this.rootCertDev);
        }
        return this.buildCertificate(this.rootCertPro);
    }

    private byte[] stripWhitespace(String str) throws UnsupportedEncodingException {
        ByteArrayOutputStream byteList = new ByteArrayOutputStream();
        if (str != null) {
            for (byte curByte : str.getBytes("UTF-8")) {
                if (curByte <= 32) continue;
                byteList.write(curByte);
            }
        }
        return byteList.toByteArray();
    }

    static {
        AVAILABLE_FINGERPRINTS.add("11111111111111111111111111111111");
        AVAILABLE_FINGERPRINTS.add("00000000000000000000000000000000");
        AVAILABLE_FINGERPRINTS.add("22222222222222222222222222222222");
    }
}

