#!/bin/sh

# this bootstraps the python dependency
# after running once and getting a new shell, you can use
#    ./scripts/deploy.py -i XXX.json
################################################################
## Change version 3.5 to 3.6
################################################################
## cp /opt/tandbergtv/cms/prepack/prepackVersion.dat /opt/tandbergtv/cms/prepack/prepackVersion.dat.bkp
## echo "3.6" > /opt/tandbergtv/cms/prepack/prepackVersion.dat

################################################################
## Get CMS version
################################################################
version=`sudo rpm -qi watchpoint-cms  | sudo grep Version | sudo awk '{print $3}'`

majorVersion=${version:0:3}

sudo echo "CMS version is $majorVersion"

################################################################
## Set LOG Environment
################################################################
sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c  'echo export LOG=/opt/tandbergtv/log/jboss.log >> /etc/bashrc'

PRE_CONFIGURED_FILE=$1

cd pysetup
sh ./pysetup.sh true 
source /etc/bashrc
cd ..

sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c  'echo export LOG=/opt/tandbergtv/cms/log/jboss.log >> /etc/bashrc'

preprocessParams=" -v $majorVersion -i patches_sysInfo.json"
inputParams=$@
inputParams+=$preprocessParams

source ./get_cluster_info.sh
setOptionValues $inputParams
echo "Start to perfrom ip address auto feed in..."
autoIpFeedIn
echo
echo "Start to verify password...."
promptForPwdInput

PRE_CONFIGURED_FILE=$1

if [ -z "$PRE_CONFIGURED_FILE" ]
then
        sudo echo "No pre-configured selection file passed in.  User will be prompt to select components directly"
        sudo python ./scripts/install.pyc -i patches_sysInfo.json -m PATCH -u $currentUser -w $password $inputParams
else
        sudo python ./scripts/install.pyc -i patches_sysInfo.json -m PATCH -p $PRE_CONFIGURED_FILE -u $currentUser -w $password $inputParams
fi

cd pysetup
sh ./pyunstall.sh true
