#!/bin/sh

################################################################
## Get CMS version
################################################################
version=`sudo rpm -qi watchpoint-cms  | sudo grep Version | sudo awk '{print $3}'`

majorVersion=${version:0:3}

sudo echo "CMS version is $majorVersion"

################################################################
## Set LOG Environment 
################################################################
sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c  "echo export LOG=/opt/tandbergtv/log/jboss.log >> /etc/bashrc"

PRE_CONFIGURED_FILE=$1

cd pysetup
sh ./pysetup.sh true 
source /etc/bashrc

preprocessParams=" -v $majorVersion -i rollback_sysInfo.json"
inputParams=$@
inputParams+=$preprocessParams

cd ..
source ./get_cluster_info.sh
setOptionValues $inputParams
echo "Start to perfrom ip address auto feed in..."
autoIpFeedIn
echo
echo "Start to verify password...."
promptForPwdInput

echo
echo "Ready to execute prepack installer..."

sudo python ./scripts/rollback.pyc -i rollback_sysInfo.json -u $currentUser -w $password $inputParams

cd pysetup
sh ./pyunstall.sh true
