#!/bin/sh
#
# Copyright (c) 2013 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Brandon Cox
# Created: Apr 22, 2013
# Description:
# Sets up the sftpuser and chroot environment for SFTP upload from the UI.
#

sudo echo "Configuring SFTP upload..."
JAILPATH=$1
if [ -z "$JAILPATH" ]; then
	sudo echo "No JAILPATH passed in.  Assuming /content."
	JAILPATH=/content
else
	sudo echo "JAILPATH is set to $JAILPATH."
fi

sudo echo "Creating $JAILPATH/lib $JAILPATH/lib64 $JAILPATH/bin $JAILPATH/sbin $JAILPATH/usr/bin $JAILPATH/uploaded directories..."
sudo mkdir -p $JAILPATH/lib $JAILPATH/lib64 $JAILPATH/bin $JAILPATH/sbin $JAILPATH/usr/bin $JAILPATH/uploaded

sudo echo "Copying necessary applications into jailroot..."
APPS="/bin/bash /bin/cp /usr/bin/dircolors /bin/ls /bin/mkdir /bin/mv /bin/rm /bin/rmdir /bin/sh /bin/su /usr/bin/groups /usr/bin/id /usr/bin/rsync /usr/bin/ssh /usr/bin/scp /sbin/unix_chkpwd"
for app in $APPS; do
	sudo cp -n $app "${JAILPATH}${app}";
done

sudo echo "Copying libs into jailroot..."
sudo cp -rn /lib64/* ${JAILPATH}/lib64

sudo echo "Creating 'black hole' in jailroot..." 
sudo mkdir -p $JAILPATH/dev
sudo touch $JAILPATH/dev/null
sudo chmod 0777 $JAILPATH/dev/*

sudo echo "Creating/copying configuration files..."
sudo mkdir -p $JAILPATH/etc
sudo cp -rn /etc/pam.d /etc/security $JAILPATH/etc
sudo cp -n /etc/profile /etc/login.defs $JAILPATH/etc

sudo sh -c "grep ^root /etc/passwd > $JAILPATH/etc/passwd"
sudo sed -i "s#501::/uploaded:/bin/bash#65533::$JAILPATH/uploaded:/bin/chroot-shell#" /etc/passwd
sudo grep ^sftpuser /etc/passwd | sudo sh -c  "sed \"s#$JAILPATH/uploaded:/bin/chroot-shell#/uploaded:/bin/sh#\" >> $JAILPATH/etc/passwd"

sudo sh -c "grep ^root /etc/group > $JAILPATH/etc/group"
sudo sh -c  "grep ^users /etc/group  >> $JAILPATH/etc/group"
sudo sh -c  "grep ^nobody /etc/group >> $JAILPATH/etc/group"
sudo sh -c  "grep ^nfsnobody /etc/group  >> $JAILPATH/etc/group"
sudo sed -i 's/sftpuser:x:501:/sftpuser:x:65533:/' /etc/group
sudo sh -c  "grep ^sftpuser /etc/group >> $JAILPATH/etc/group"

sudo sh -c "grep ^sftpuser /etc/shadow > $JAILPATH/etc/shadow"


sudo grep -e "^\s*Chroot" /etc/ssh/sshd_config > /dev/null 2>&1
if [ "$?" -eq "0" ]; then
	sudo echo "Copying out bad line in sshd_config and restarting sshd service..."
	sudo sed -r -i -e 's/^(\s)\1+ChrootDirectory/#\1ChrootDirectory/g' /etc/ssh/sshd_config
	sudo service sshd restart
fi

if [ ! -f "/bin/chroot-shell" ]; then
	sudo echo "Creating /bin/chroot-shell file..."
	sudo sh -c "echo '#!/bin/sh' > /bin/chroot-shell"
	sudo sh -c 'echo "umask 0002" >> /bin/chroot-shell'
	sudo sh -c "echo \"`which sudo` `which chroot` $JAILPATH /bin/su - \$USER\" \"\$@\" >> /bin/chroot-shell"
	sudo chmod 755 /bin/chroot-shell
fi

sudo grep sftpuser /etc/sudoers > /dev/null 2>&1
if [ ! "$?" -eq "0" ]; then
	if [ -f "/etc/sudoers.tmp" ]; then
		sudo echo "/etc/sudoers.tmp file already exists.  Either someone is modifying /etc/sudoers or this finally needs to be removed manually..."
		sudo echo "Exiting with error code 1."
		exit 1;
	fi
	sudo echo "Adding sftpuser entry into /etc/sudoers..."
   	sudo touch /etc/sudoers.tmp
	sudo cp /etc/sudoers /tmp/sudoers.new
	sudo sh -c  "echo -e \"\n\nsftpuser     ALL=NOPASSWD: /usr/sbin/chroot, /bin/su - sftpuser, /usr/sbin/chroot $JAILROOT /bin/su - sftpuser\n\" >> /tmp/sudoers.new"
	sudo visudo -c -f /tmp/sudoers.new
	if [ "$?" -eq "0" ]; then
		sudo cp /tmp/sudoers.new /etc/sudoers;
	fi
	sudo rm -f /etc/sudoers.tmp
fi

sudo echo "SFTP upload configuration complete."
