try:
    import unittest2 as unittest
except Exception:
    import unittest

def load_tests(loader, tests, pattern):
    ''' Discover and load all unit tests in all files named "*Test.py" under current directory
    '''
    suite = unittest.TestSuite()
    for all_test_suite in unittest.defaultTestLoader.discover('.', pattern='*Test.py'):
        for test_suite in all_test_suite:
            suite.addTests(test_suite)
    return suite

if __name__ == '__main__':
    unittest.main()    