<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:cmsut="http://www.ericsson.com/cms/utility" version="2.0" exclude-result-prefixes="xs xsi cmsut">
	<xsl:import href="from/utility.xsl"/>
	<xsl:variable name="runTime" select="$Title/Fields/Duration/Duration"/>
	
	<xsl:template match="/ECMFSpec/Package/Movie">
        <markers>
            <xsl:apply-templates select="Fields/Avails/Avail"/>
        </markers>
	</xsl:template>
	
    <xsl:template match="Fields/Avails/Avail">
        
        <marker>
            <xsl:element name="start_offset">
                <xsl:choose>
                    <xsl:when test="TimeCodeTwo">
	                    <xsl:variable name="timcode2" select="TimeCodeTwo"/>
	                    <xsl:call-template name="convertAvilTimeCode">
	                       <xsl:with-param name="timecode" select="$timcode2"/>
	                    </xsl:call-template>                    
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="curAvilInd" select="position()"/>
                        <xsl:apply-templates select="../../../UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeTwo']">
                            <xsl:with-param name="index" select="string($curAvilInd)"/>
                        </xsl:apply-templates>
                    </xsl:otherwise>
                </xsl:choose>                
            </xsl:element>
            <xsl:element name="duration">
                <xsl:value-of select="60*1000"/>
            </xsl:element>
            <xsl:element name="marker_type">
                <xsl:value-of select="Type"/>
            </xsl:element>
            <xsl:element name="marker_data">
                <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                <xsl:value-of select="Position"/>
                <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
            </xsl:element>
        </marker>       
    </xsl:template>
    
    <xsl:template match="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeTwo']">
        <xsl:param name="index"/>
        <xsl:variable name="indices" select="@indices"/>
        <xsl:variable name="indList" select="tokenize($indices, '\s*,')"/>
        <xsl:variable name="curIndex" select="$indList[3]"/>
        <xsl:if test="$curIndex=$index">
            <xsl:call-template name="convertAvilTimeCode">
                <xsl:with-param name="timecode" select="@value"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="convertAvilTimeCode">
        <xsl:param name="timecode"/>
        <xsl:choose>
            <xsl:when test="upper-case($timecode)='BOS'">
                <xsl:value-of>0</xsl:value-of>
            </xsl:when>
            <xsl:when test="upper-case($timecode)='EOS'">
                <xsl:value-of select="cmsut:convertRunTimeToAzukiFormat($runTime)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="cmsut:convertTimeCodeToAzukiFormat($timecode)"/>
            </xsl:otherwise>
        </xsl:choose>         
    </xsl:template>
</xsl:stylesheet>
