<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:cmsut="http://www.ericsson.com/cms/utility" version="2.0" exclude-result-prefixes="xs xsi cmsut">
	<xsl:import href="from/utility.xsl"/>
	
	<xsl:variable name="CustomField" select="$Title/Fields/CustomFields/CustomField"/>
	
	<xsl:template match="/ECMFSpec/Package/Title">
		<xsl:if test="Fields/Title/ShortTitle/Value">
			<name>
				<xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
				<xsl:value-of select="Fields/Title/ShortTitle/Value"/>
				<xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
			</name>				
		</xsl:if>		
				
     	<xsl:apply-templates select="Fields/CustomFields/CustomField[not(matches(@name,'AzukiM(\d+)|Azuki_Cdn_Federation_Name_(\d+)|Azuki_Audio_Tracks_Track_(\d+)|AzukiCdnProfiles'))]"/>

		<xsl:choose>
			<xsl:when test="Fields/CustomFields/CustomField[matches(@name,'Azuki_Cdn_Federation_Name_(\d+)')]">
				<cdn_federation>
					<xsl:apply-templates select="Fields/CustomFields/CustomField[matches(@name,'Azuki_Cdn_Federation_Name_(\d+)')]"/>
				</cdn_federation>
			</xsl:when>
	
			<xsl:otherwise>
				<xsl:apply-templates select="Fields/CustomFields/CustomField[matches(@name,'AzukiCdnProfiles')]"/>
			</xsl:otherwise>
		</xsl:choose>
 
		<xsl:if test="Fields/CustomFields/CustomField[matches(@name,'Azuki_Audio_Tracks_Track_(\d+)')]">
			<audio_tracks>
				<xsl:apply-templates select="Fields/CustomFields/CustomField[matches(@name,'Azuki_Audio_Tracks_Track_(\d+)')]"/>
			</audio_tracks>
		</xsl:if>
	
 
     	<xsl:if test="Fields/CustomFields/CustomField[matches(@name,'AzukiM(\d+)')]">
			<metadata>
				<xsl:apply-templates select="Fields/CustomFields/CustomField[matches(@name,'AzukiM(\d+)')]"/>
			</metadata>
		</xsl:if>
			
		<xsl:if test="Fields/Rights/LicensingWindowStart">
			<activate_date>
				<xsl:variable name="dateStr" select="Fields/Rights/LicensingWindowStart"/>
				<xsl:value-of select="cmsut:convertCMSDayTimeToAzukiFormat($dateStr)"/> 
			</activate_date>
		</xsl:if>
		<xsl:if test="Fields/Rights/LicensingWindowEnd">
			<deactivate_date>
				<xsl:variable name="dateStr" select="Fields/Rights/LicensingWindowEnd"/>
				<xsl:value-of select="cmsut:convertCMSDayTimeToAzukiFormat($dateStr)"/> 
			</deactivate_date>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="Fields/CustomFields/CustomField">
		<xsl:variable name="name" select="@name"/>
	
		<xsl:if test="matches($name,'AzukiVideoURL')">
			<xsl:if test="Value">
				<url>
					<xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
					<xsl:value-of select="Value"/>
					<xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
				</url>				
			</xsl:if>
		</xsl:if>		
		
		<xsl:if test="matches($name,'AzukiEmbeddedCaption')">
			<embedded_caption>
				<xsl:value-of select="lower-case(Value)"/>
			</embedded_caption>				
		</xsl:if>
		
		<xsl:if test="matches($name,'AzukiIngestionProfile')">
			<xsl:if test="Value">
				<ingestion_profile>
					<xsl:value-of select="Value"/>
				</ingestion_profile>
			</xsl:if>				
		</xsl:if>		
		
		<xsl:if test="matches($name,'AzukiPriority')">
			<xsl:if test="IntegerValue">
				<priority>
					<xsl:value-of select="IntegerValue"/>
				</priority>
			</xsl:if>				
		</xsl:if>	
		
		<xsl:if test="matches($name,'AzukiCaptionLocation')">
			<xsl:if test="lower-case($CustomField[@name='AzukiEmbeddedCaption']/Value)='false'">
				<caption_location>
					<xsl:value-of select="Value"/>
				</caption_location>	
			</xsl:if>			
		</xsl:if>		
		
		<xsl:if test="matches($name,'AzukiRetranscode_All')">
			<xsl:if test="BooleanValue='true'">
				<retranscode_formats>
					<all><xsl:value-of select="BooleanValue"/></all>
				</retranscode_formats>				
			</xsl:if>
		</xsl:if>
		
		<xsl:if test="matches($name,'AzukiCdnProfiles')">
			<xsl:call-template name="AzukiCdnProfiles">
				<xsl:with-param name="cdnProfiles" select="Value"/>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="matches($name,'AzukiM(\d+)')">
			<xsl:call-template name="M_Field">
				<xsl:with-param name="name" select="@name" />
				<xsl:with-param name="value" select="Value" />
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="matches($name,'Azuki_Cdn_Federation_Name_(\d+)')">
			<xsl:call-template name="Azuki_Cdn_Federation">
				<xsl:with-param name="name" select="@name" />
				<xsl:with-param name="value" select="Value" />
			</xsl:call-template>
		</xsl:if>

		<xsl:if test="matches($name,'Azuki_Audio_Tracks_Track_(\d+)')">
			<xsl:call-template name="Azuki_Audio_Tracks">
				<xsl:with-param name="name" select="@name" />
				<xsl:with-param name="value" select="Value" />
			</xsl:call-template>
		</xsl:if>

		<xsl:if test="matches($name,'AzukiPublish_Date')">
			<xsl:if test="DatetimeValue">
				<publish_date>
					<xsl:variable name="dateStr" select="DatetimeValue"/>
					<xsl:value-of select="cmsut:convertCMSDayTimeToAzukiFormat($dateStr)"/> 
				</publish_date>
			</xsl:if>				
		</xsl:if>
		
		<xsl:if test="matches($name,'expire_date')">
			<xsl:if test="DatetimeValue">
				<expire_date>
					<xsl:variable name="dateStr" select="DatetimeValue"/>
					<xsl:value-of select="cmsut:convertCMSDayTimeToAzukiFormat($dateStr)"/> 
				</expire_date>
			</xsl:if>	
		</xsl:if>					
				
		<xsl:if test="matches($name,'AzukiRating')">
			<xsl:if test="Value">
				<rating>
					<xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
					<xsl:value-of select="Value"/>
					<xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
				</rating>				
			</xsl:if>
		</xsl:if>
        
		<!-- generate azuki generic metadata fields with pattern "Azuki_Ingest_" -->
		<xsl:if test="matches($name,'Azuki_Ingest_(.+)')">
			<xsl:variable name="field_name" select="substring-after($name,'Azuki_Ingest_')"/>
			
			<xsl:variable name="value">
				<xsl:choose>
					<xsl:when test="BooleanValue">
						<xsl:value-of select="BooleanValue"/>
					</xsl:when>
					<xsl:when test="Value">
						<xsl:value-of select="Value"/>
					</xsl:when>
					<xsl:when test="DatetimeValue">
						<xsl:variable name="dateStr" select="DatetimeValue"/>
						<xsl:value-of select="cmsut:convertCMSDayTimeToAzukiFormat($dateStr)"/>
					</xsl:when>
					<xsl:when test="IntegerValue">
						<xsl:value-of select="IntegerValue"/>
					</xsl:when>
					<xsl:when test="TimeValue">
						<xsl:value-of select="TimeValue"/>
					</xsl:when>
					<xsl:when test="FloatValue">
						<xsl:value-of select="FloatValue"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			
			<xsl:call-template name="Ingest_Field">
				<xsl:with-param name="name" select="$field_name" />
				<xsl:with-param name="value" select="$value" />
			</xsl:call-template>
		</xsl:if>

	</xsl:template>
	
	<xsl:template name="AzukiCdnProfiles">
		<xsl:param name="cdnProfiles"/>
		<cdn_profiles>
			<xsl:for-each select="tokenize($cdnProfiles,',')">
				<xsl:if test=".">
					<cdn_profile>
						<xsl:value-of select="."/>
					</cdn_profile>	
				</xsl:if>		
			</xsl:for-each>	
		</cdn_profiles>
	</xsl:template>
	
	<xsl:template name="M_Field">
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:variable name="m_field" select="concat('m', substring-after($name,'AzukiM'))"/>
		<xsl:if test="$value">
			<xsl:element name="{$m_field}">
				<xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
				<xsl:value-of select="$value"/>
				<xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
			</xsl:element>
		</xsl:if>
		</xsl:template>

		<xsl:template name="Azuki_Cdn_Federation">
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:if test="$value and $value!=''">
			<xsl:variable name="profile_group_number" select="substring-after($name,'Azuki_Cdn_Federation_Name_')"/>
			<cdn_profile>
			<xsl:element name="name">
				<xsl:value-of select="$value"/>
			</xsl:element>
			<xsl:element name="priority">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Cdn_Federation_Priority_',$profile_group_number)]/Value"/>
			</xsl:element>
			<xsl:element name="threshold">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Cdn_Federation_Threshold_', $profile_group_number)]/Value"/>
			</xsl:element>
			<xsl:element name="origin">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Cdn_Federation_Origin_',$profile_group_number)]/Value"/>
			</xsl:element>
			<xsl:element name="edge">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Cdn_Federation_Edge_',$profile_group_number)]/Value"/>
			</xsl:element>
			</cdn_profile>
		</xsl:if>
		
	</xsl:template>		
	
	<xsl:template name="Azuki_Audio_Tracks">
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:if test="$value and $value!=''">
			<xsl:variable name="track_group_number" select="substring-after($name,'Azuki_Audio_Tracks_Track_')"/>
			<audio_track>
			<xsl:element name="track">
				<xsl:value-of select="$value"/>
			</xsl:element>
			<xsl:element name="language">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Audio_Track_Language_',$track_group_number)]/Value"/>
			</xsl:element>
			<xsl:element name="still_image_location">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Audio_Track_Still_Image_Location_', $track_group_number)]/Value"/>
			</xsl:element>
			<xsl:element name="subtitle_location">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Audio_Track_Subtitle_Location_',$track_group_number)]/Value"/>
			</xsl:element>
			<xsl:element name="name">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Audio_Track_Name_',$track_group_number)]/Value"/>
			</xsl:element>
			<xsl:element name="default_track">
				<xsl:value-of select="$CustomField[@name=concat('Azuki_Audio_Track_Default_Track_',$track_group_number)]/Value"/>
			</xsl:element>
			</audio_track>
		</xsl:if>
		
	</xsl:template>
    
	<xsl:template name="Ingest_Field">
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:if test="$value">
			<xsl:element name="{$name}">
				<xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
				<xsl:value-of select="$value"/>
				<xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
			</xsl:element>
		</xsl:if>
	</xsl:template>	
</xsl:stylesheet>
