#!/bin/bash
################################################
# A script for delete expire content with alert.
################################################

ALERT_CMD="sh /opt/tandbergtv/cms/scripts/common-alert-client/bin/alertclient.sh"
ALERT_PATTERN="Content Deleted From Unmapped Folder"

file=$1


if [ -f "$file" ]; then
	echo "[`date '+%Y-%m-%d %H:%M:%S'`] Delete expire file: $file" >> /tmp/cms_file_housekeep.log
	rm -f "$file"
	
	if [ -f "$file" ];then
		echo "[`date '+%Y-%m-%d %H:%M:%S'`] Failed to delete $file" >> /tmp/cms_file_housekeep.log
	else
		$ALERT_CMD "${ALERT_PATTERN} $file"
		echo "[`date '+%Y-%m-%d %H:%M:%S'`] Delete expire file: $file success." >> /tmp/cms_file_housekeep.log
	fi
fi

exit;

