#!/bin/sh

################################################################
## Get CMS version
################################################################
version=`rpm -qi watchpoint-cms  | grep Version | awk '{print $3}'`
if [ -z "$version" ]
then
version=`conary q | grep watchpoint-cms | awk '{print $1}' | cut -d '=' -f2`
fi

majorVersion=${version:0:3}

isCMS4_0=false
if [ "$majorVersion" != "3.1" ] && [ "$majorVersion" != "3.0" ]
then
   isCMS4_0=true
   echo "CMS version is 4.0"
else
   echo "CMS version is $majorVersion"
fi

################################################################
## Set LOG Environment 
################################################################
if [ "$isCMS4_0" == true ]; then
   grep LOG /etc/bashrc > /dev/null || echo export LOG=/opt/tandbergtv/log/jboss.log >> /etc/bashrc
else
   grep LOG /etc/bashrc > /dev/null || echo export LOG=/opt/tandbergtv/cms/log/jboss.log >> /etc/bashrc
fi

PRE_CONFIGURED_FILE=$1

cd pysetup
sh ./pysetup.sh $isCMS4_0
cd ..
source /etc/bashrc
python ./scripts/rollback.pyc -i rollback_sysInfo.json

cd pysetup
sh ./pyunstall.sh $isCMS4_0