#!/usr/bin/env python
# Name:    archivefiles-cgi
# Notes:   Create tar file for source files
#
import tarfile
import os
import urlparse
import sys

class ArchiveFiles:
        def __init__(self):
            self.sourceFileList = None

        def createTar(self, sourceFiles, destPath):
            tar=tarfile.open(destPath,'w',dereference=True)
            if self.sourceFileList is not None:
                for file in self.sourceFileList:
                    tar.add(file,arcname=os.path.basename(file))
            elif os.path.isdir(sourceFiles):
                for root,dir,files in os.walk(sourceFiles):
                    for file in files:
                        fullpath=os.path.join(root,file)
                        tar.add(fullpath,arcname=file)
            else:
                tar.add(sourceFiles,arcname=os.path.basename(sourceFiles))
            tar.close()
            print "Create tar file successfully."

        def parseURL(self, url):
            parsed = urlparse.urlparse(url)

            if urlparse.parse_qs(parsed.query).has_key('sourcefiles'):
                sourcefiles = urlparse.parse_qs(parsed.query)['sourcefiles'].pop()

            if urlparse.parse_qs(parsed.query).has_key('destpath'):
                destpath = urlparse.parse_qs(parsed.query)['destpath'].pop()
            return (sourcefiles, destpath)

        def validatePara(self, sourceFiles, destPath):
            destFolder = os.path.split(destPath)[0]
            if not os.path.exists(destFolder):
                raise Exception('Destination folder is not exist: ' + destFolder)
            if sourceFiles.find(',')>0:
                self.sourceFileList=sourceFiles.split(',')
                for file in self.sourceFileList:
                    if not os.path.exists(file):
                        raise Exception('File of source file list is not exist: ' + file)
            elif not os.path.exists(sourceFiles):
                raise Exception('Source file or folder is not exist: ' + sourceFiles)
            else:
                if os.path.isdir(sourceFiles):
                    if len(os.listdir(sourceFiles))==0:
                        raise Exception('No file is under source folder: ' + sourceFiles)

def main():
        print 'Content-type: text/plain; charset=utf-8\n\n'
        if len(sys.argv) < 2:
            print "Error: passed arguments to archivefiles cgi script are not correct"
            exit(-1)
        '''sys.arg[0] is archivefiles.py'''
        url = sys.argv[1]

        archiveFiles = ArchiveFiles()
        sourceFiles, destPath = archiveFiles.parseURL(url)
        try:
            archiveFiles.validatePara(sourceFiles, destPath)
            archiveFiles.createTar(sourceFiles, destPath)
        except Exception, e:
            print "ERROR: Create tar file failed."
            print e

if __name__ == "__main__":
        main()
