<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns">

<xsl:template match="tns:Fields/tns:Rating/tns:Value">
	<xsl:variable name="ratingValue" select="."/>
	<rating>
		<xsl:attribute name="rating_system">
			<xsl:choose> 
				<xsl:when test="../tns:System">
					<xsl:value-of select="../tns:System" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="exists(index-of(('G','PG','PG-13','R','NC-17'),.))"><xsl:text>MPAA</xsl:text></xsl:when>
						<xsl:when test="starts-with(.,'TV')"><xsl:text>VCHIP</xsl:text></xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:attribute name="value">
			<xsl:value-of select="." />
		</xsl:attribute>
	</rating>
</xsl:template>
<xsl:template match="tns:Fields/tns:Review">
	<review>
		<xsl:attribute name="type">
			<xsl:value-of select="tns:Type" />
		</xsl:attribute>
		<xsl:if test="tns:Author">
			<xsl:attribute name="author">
				<xsl:value-of select="tns:Author" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Language">
			<xsl:attribute name="language">
				<xsl:value-of select="tns:Language" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Url">
			<xsl:attribute name="url">
				<xsl:value-of select="tns:Url" />
			</xsl:attribute>
		</xsl:if>
		<xsl:value-of select="tns:Value" />
	</review>
</xsl:template>
</xsl:stylesheet>
