#!/bin/sh
#
# Copyright (c) 2013 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Jerish Lin
# Created: Jul 9, 2013
# Description:
# Use Shell to do additional jobs after installation is done, mainly for upgrading.
#
echo "POST INSTALLATION: Do something additional after installation.."

SUB_SYSTEM_PATH=/opt/tandbergtv/cms/workflow/plugins/subsystems

declare -a SUB_SYSTEM=("cms-distribution")

for ss in "${SUB_SYSTEM[@]}"
do
	dir="$SUB_SYSTEM_PATH/$ss"
	if [ -d "$dir" ]
	then
		rm -rf "$dir"
		echo "Removed Directory $dir"
	else
		echo "Directory not exists: $dir"
	fi
done

CMS_CLUSER_PROP=/opt/tandbergtv/cms/conf/workflow/cluster.properties
PREPACK_CLUSER_PROP=/opt/tandbergtv/cms/conf/prepack/cluster.properties
PREPACK_CLUSER_PROP_FOLDER=/opt/tandbergtv/cms/conf/prepack
if [ -f "$CMS_CLUSER_PROP" ] 
then
    echo "copying $CMS_CLUSER_PROP to $PREPACK_CLUSER_PROP"
    mkdir -p $PREPACK_CLUSER_PROP_FOLDER
    cp $CMS_CLUSER_PROP $PREPACK_CLUSER_PROP
    chmod 755 $PREPACK_CLUSER_PROP

    sed -i -e 's/workflow/prepack/g' $PREPACK_CLUSER_PROP
else
    echo "$CMS_CLUSER_PROP does not exists!"
fi

CF_DATATYPE_MAPPING_DAT=/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata/resources/cfDataTypeMapping.dat
if [ -f "$CF_DATATYPE_MAPPING_DAT" ] 
then
    echo "remove $CF_DATATYPE_MAPPING_DAT"
    rm -rf $CF_DATATYPE_MAPPING_DAT
else
    echo "$CF_DATATYPE_MAPPING_DAT does not exists!"
fi

echo "POST INSTALLATION: done.."