#!/bin/sh
#
# Copyright (c) 2013 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Jerish Lin
# Created: Jul 9, 2013
# Description:
# Use Shell to do additional jobs after installation is done, mainly for upgrading.
#

echo "PRE INSTALLATION: Unintall previous resource type rpms."

declare -a UNINSTALL_RPMS_PREFIX=("Utilities" "variable-functions" "cablelabs-vod-1.1-metadata-parser")
#  "mediaroom-backend" "mediaroom-branch" 

for ur in "${UNINSTALL_RPMS_PREFIX[@]}"
do
	v_rpm=`rpm -qa | grep $ur`
	if [ "$v_rpm" = "" ]
	then
		echo "rpm $ur not installed."
	else
		rpm -e $ur
		echo "Uninstalled rpm $ur."	
	fi
done

echo "PRE INSTALLATION: Unintall previous resource group rpms."

declare -a UNINSTALL_RPMS_RG_PREFIX=("cms-distribution-groups")

for urg in "${UNINSTALL_RPMS_RG_PREFIX[@]}"
do
	v_rpmrg=`rpm -qa | grep $urg`
	if [ "$v_rpmrg" = "" ]
	then
		echo "rpm $urg not installed."
	else
		rpm -e $urg
		echo "Uninstalled rpm resource group $urg."
	fi
done

echo "PRE INSTALLATION: Unintall previous prepack services rpms."

declare -a UNINSTALL_RPMS_SERVICES_PREFIX=("prepack-services-default")

for svc in "${UNINSTALL_RPMS_SERVICES_PREFIX[@]}"
do
	v_rpmsrc=`rpm -qa | grep $svc`
	if [ "$v_rpmsrc" = "" ]
	then
		echo "rpm $svc not installed."
	else
		rpm -e $svc
		echo "Uninstalled rpm Prepack Services $svc."
	fi
done

echo "PRE INSTALLATION: done.."