/*
 * Data patch for filtering validation rules and targeting rules which do not include UA targeting rule for UA title
 * Purpose: All validation rule should not work for UA title, and all the targeting rule except 'Mediaroom_UA Targeting' should not work for UA title.
 * Author: Zhiling Zhang on 7 May 2015
 */
DECLARE
   recursor SYS_REFCURSOR;
   t_packageid numeric(10,0);
   t_rulesetid numeric(10,0);
   rulesetname character varying(255);
   filterid numeric(10,0);
   record numeric(10,0);
   nodenum numeric(10,0);
   t_rootnodeid numeric(10,0);
   t_predicatedid numeric(10,0);
   
BEGIN
   SELECT PACKAGEID INTO t_packageid from TRE_PACKAGE where NAME='VALIDATION';
   OPEN recursor FOR SELECT RULESETID,RULENAME,TITLEFILTERID from TRE_RULESET t where (PACKAGEID=t_packageid or PACKAGEID=(SELECT PACKAGEID from TRE_PACKAGE where NAME='TARGETING')) AND NOT EXISTS(SELECT * from TRE_RULESET
 where RULESETID=t.RULESETID and RULENAME in ('CL11_I06 rules','CL11_Check total length','Mediaroom_UA Targeting'));
   LOOP
     FETCH recursor INTO t_rulesetid,rulesetname,filterid;
     DBMS_OUTPUT.PUT_LINE('processing rule:'||rulesetname||',rulesetid:'||t_rulesetid||',filterid:'||filterid);
     EXIT WHEN recursor%NOTFOUND;
     SELECT count(*) INTO record from TRE_TITLEFILTER where TITLEFILTERID=filterid and ROOTNODEID is null;
     IF record>0  THEN
       t_rootnodeid:=TRE_EXPNODE_SEQ.nextval;
       INSERT INTO TRE_EXPNODE VALUES(t_rootnodeid,'List', null,'AND',null,null,SYSDATE,SYSDATE);
       UPDATE TRE_TITLEFILTER SET ROOTNODEID=t_rootnodeid where TITLEFILTERID=filterid;
       DBMS_OUTPUT.PUT_LINE('root node id is null,after updated TRE_TITLEFILTER table,root node id is:'||t_rootnodeid);
     END IF;
     SELECT ROOTNODEID INTO t_rootnodeid from TRE_TITLEFILTER where TITLEFILTERID=filterid;
     DBMS_OUTPUT.PUT_LINE('root node id is:'||t_rootnodeid);
     SELECT count(*) INTO nodenum from TRE_EXPNODE exp where PARENTID=t_rootnodeid and exists (SELECT * from TRE_PREDICATE pre where FIELDLEFT='/Fields/ContentType' and pre.PREDICATEID=exp.PREDICATEID); 
     IF nodenum=0 THEN
       t_predicatedid:=TRE_PREDICATE_SEQ.nextval;
       INSERT INTO TRE_PREDICATE VALUES(t_predicatedid,'V',0,'/Fields/ContentType',null,'PACKAGE/TITLE',null,'ASSET',null,1,'EQUAL',null,null,0,SYSDATE,SYSDATE);
       INSERT INTO TRE_PREDICATEVALUE VALUES(t_predicatedid,'UNIVERSALASSET',0);
       INSERT INTO TRE_EXPNODE VALUES(TRE_EXPNODE_SEQ.nextval,'Value',t_predicatedid,null,t_rootnodeid,(SELECT count(*) from TRE_EXPNODE where PARENTID=t_rootnodeid),SYSDATE,SYSDATE);
       DBMS_OUTPUT.PUT_LINE('process complete for rule:'||t_rulesetid);
     END IF;
   END LOOP;
   CLOSE recursor;
END;
/
COMMIT;
