#!/bin/sh
# this bootstraps the python dependency
# after running once and getting a new shell, you can use
#  ./scripts/deploy.py -i XXX.json

################################################################
## Get CMS version
################################################################
version=`rpm -qi watchpoint-cms  | grep Version | awk '{print $3}'`
if [ -z "$version" ]
then
version=`conary q | grep watchpoint-cms | awk '{print $1}' | cut -d '=' -f2`
fi

majorVersion=${version:0:3}

isCMS4_0=false
if [ "$majorVersion" != "3.1" ] && [ "$majorVersion" != "3.0" ]
then
   isCMS4_0=true
   echo "CMS version is $majorVersion"
else
   echo "CMS version is $majorVersion"
fi

################################################################
## Set LOG Environment 
################################################################
if [ "$isCMS4_0" == true ]; then
   grep LOG /etc/bashrc > /dev/null || echo export LOG=/opt/tandbergtv/log/jboss.log >> /etc/bashrc
else
   grep LOG /etc/bashrc > /dev/null || echo export LOG=/opt/tandbergtv/cms/log/jboss.log >> /etc/bashrc
fi

PRE_CONFIGURED_FILE=$1

cd pysetup
sh ./pysetup.sh $isCMS4_0
source /etc/bashrc
cd ..
if [ -z "$PRE_CONFIGURED_FILE" ]
then
	echo "No pre-configured selection file passed in.  User will be prompted to select components directly"
	python ./scripts/install.pyc -i install_sysInfo.json
else
	python ./scripts/install.pyc -i install_sysInfo.json -p $PRE_CONFIGURED_FILE
fi

cd pysetup
sh ./pyunstall.sh $isCMS4_0
