<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:cmsut="http://www.ericsson.com/cms/utility" version="2.0" exclude-result-prefixes="xs xsi cmsut">
	<xsl:import href="from/utility.xsl"/>
	
	<xsl:variable name="CustomField" select="$Title/Fields/CustomFields/CustomField"/>
	
	<xsl:template match="/ECMFSpec/Package/Title">
     	<xsl:if test="Fields/CustomFields/CustomField[matches(@name,'Azuki_Entitlement_(.+)')]">
			<xsl:apply-templates select="Fields/CustomFields/CustomField[matches(@name,'Azuki_Entitlement_(.+)')]"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="Fields/CustomFields/CustomField">
		<xsl:variable name="name" select="@name"/>
	
		<!-- generate azuki client right payload according to custom field name matching pattern "Azuki_Ingest_" -->
		<xsl:if test="matches($name,'Azuki_Entitlement_(.+)')">
			<xsl:variable name="field_name" select="substring-after($name,'Azuki_Entitlement_')"/>
			
			<xsl:variable name="value">
				<xsl:choose>
					<xsl:when test="BooleanValue">
						<xsl:value-of select="BooleanValue"/>
					</xsl:when>
					<xsl:when test="Value">
						<xsl:value-of select="Value"/>
					</xsl:when>
					<xsl:when test="DatetimeValue">
						<xsl:variable name="dateStr" select="DatetimeValue"/>
						<xsl:value-of select="cmsut:convertCMSDayTimeToAzukiFormat($dateStr)"/>
					</xsl:when>
					<xsl:when test="IntegerValue">
						<xsl:value-of select="IntegerValue"/>
					</xsl:when>
					<xsl:when test="TimeValue">
						<xsl:value-of select="TimeValue"/>
					</xsl:when>
					<xsl:when test="FloatValue">
						<xsl:value-of select="FloatValue"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			
			<xsl:call-template name="ClientRight_Field">
				<xsl:with-param name="name" select="$field_name" />
				<xsl:with-param name="value" select="$value" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="ClientRight_Field">
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:if test="$value">
			<xsl:element name="{$name}">
				<xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
				<xsl:value-of select="$value"/>
				<xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
			</xsl:element>
		</xsl:if>
	</xsl:template>	
</xsl:stylesheet>