<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1"
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">

	<xsl:import href="from/common.xsl"/>
	
	<xsl:template match="/ECMFSpec/Package">
		<Asset xsi:type="offer:OfferType">
			<!-- <xsl:attribute name="uriId"><xsl:value-of select="concat( $PackageProviderId, '/Offer/', $PackageAssetId )"/></xsl:attribute> -->
			<xsl:call-template name="encodeUri">
				<xsl:with-param name="providerId" select="$PackageProviderId" />
				<xsl:with-param name="assetType" select="'/Offer/'" />
				<xsl:with-param name="fieldId" select="$PackageAssetId" />
			</xsl:call-template>
			<xsl:call-template name="AMS_1" />
			<xsl:call-template name="AMS_2" />
			
			<core:Ext>
				<xsl:if test="$Title/Fields/Content/Type or $Title/Fields/OSVOD/BusinessClasses/BusinessClass or $Title/Fields/OSVOD/ViewingWindows/ViewingWindow or $Title/Fields/OSVOD/CustomSortPriority or $Title/Fields/OSVOD/CustomSortPriority2 or $Title/Fields/OSVOD/CustomSortPriority3 or $Title/Fields/OSVOD/CustomSortPriority4 or $Title/Fields/OSVOD/CustomSortPriority5 or $Title/Fields/OSVOD/CustomSortPriority6 or $Title/Fields/OSVOD/CustomSortPriority7 or $Title/Fields/OSVOD/CustomSortPriority8 or $Title/Fields/OSVOD/CustomSortPriority9 or $Title/Fields/OSVOD/CustomSortPriority10 or $Title/Fields/OSVOD/DownloadBusinessClass">
					<ericsson:OfferExt>
						<xsl:if test="$Title/Fields/Content/Type">
							<ericsson:Type>
								<xsl:value-of select="$Title/Fields/Content/Type"/>
							</ericsson:Type>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/DownloadBusinessClass">
								<ericsson:DownloadBusinessClass>
									<xsl:value-of select="$Title/Fields/OSVOD/DownloadBusinessClass"/>
								</ericsson:DownloadBusinessClass>	
						</xsl:if>						
						<xsl:if test="$Title/Fields/OSVOD/BusinessClasses/BusinessClass">
								<xsl:for-each select="$Title/Fields/OSVOD/BusinessClasses/BusinessClass">
									<ericsson:BusinessClass>
										<xsl:value-of select="."/>
									</ericsson:BusinessClass>
								</xsl:for-each>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/ViewingWindows/ViewingWindow">
							<xsl:for-each select="$Title/Fields/OSVOD/ViewingWindows/ViewingWindow">
								<ericsson:ViewingWindow>
									<xsl:attribute name="ViewingWindowStart">
										<xsl:value-of select="substring-before(., '::')"/>
									</xsl:attribute>	
									<xsl:attribute name="ViewingWindowEnd">
										<xsl:value-of select="substring-after(., '::')"/>
									</xsl:attribute>
								</ericsson:ViewingWindow>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority">
							<ericsson:CustomSortPriority>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority"/>
							</ericsson:CustomSortPriority>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority2">
							<ericsson:CustomSortPriority2>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority2"/>
							</ericsson:CustomSortPriority2>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority3">
							<ericsson:CustomSortPriority3>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority3"/>
							</ericsson:CustomSortPriority3>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority4">
							<ericsson:CustomSortPriority4>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority4"/>
							</ericsson:CustomSortPriority4>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority5">
							<ericsson:CustomSortPriority5>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority5"/>
							</ericsson:CustomSortPriority5>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority6">
							<ericsson:CustomSortPriority6>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority6"/>
							</ericsson:CustomSortPriority6>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority7">
							<ericsson:CustomSortPriority7>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority7"/>
							</ericsson:CustomSortPriority7>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority8">
							<ericsson:CustomSortPriority8>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority8"/>
							</ericsson:CustomSortPriority8>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority9">
							<ericsson:CustomSortPriority9>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority9"/>
							</ericsson:CustomSortPriority9>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/CustomSortPriority10">
							<ericsson:CustomSortPriority10>
								<xsl:value-of select="$Title/Fields/OSVOD/CustomSortPriority10"/>
							</ericsson:CustomSortPriority10>
						</xsl:if>
					</ericsson:OfferExt>
				</xsl:if>
				<xsl:apply-templates select="Fields/CustomFields/CustomField" />
			</core:Ext>
			
			<!-- 
			<xsl:for-each select="$Title/Fields/Categories/Category">
				<offer:Presentation>
					<xsl:if test="Text">
						<offer:CategoryRef>
							<xsl:call-template name="encodeCategoryUri" />
						</offer:CategoryRef>
					</xsl:if>
					<xsl:if test="$Title/Fields/Rights/NewReleaseWindow">
						<offer:DisplayAsNew>
							<xsl:value-of select="concat('P',$Title/Fields/Rights/NewReleaseWindow,'D')"/>
						</offer:DisplayAsNew>
					</xsl:if>
					<xsl:if test="$Title/Fields/Rights/DisplayAsLastChance">
						<offer:DisplayAsLastChance>
							<xsl:value-of select="concat('P',$Title/Fields/Rights/DisplayAsLastChance,'D')"/>
						</offer:DisplayAsLastChance>
					</xsl:if>
				</offer:Presentation>
			</xsl:for-each>
			-->
			
			<!-- translate from Temporiry Category group of package
		   /Fields[1]/CategoriesTmp[1]/Category[pos1]/Text[pos2] -->
			<xsl:for-each select="$Package/Fields/CategoriesTmp/Category">
				<xsl:if test="Text">
					<offer:Presentation>
							<offer:CategoryRef>
								<xsl:call-template name="encodeCategoryUri" />
							</offer:CategoryRef>
						<xsl:if test="$Title/Fields/Rights/NewReleaseWindow">
							<offer:DisplayAsNew>
								<xsl:value-of select="concat('P',$Title/Fields/Rights/NewReleaseWindow,'D')"/>
							</offer:DisplayAsNew>
						</xsl:if>
						<xsl:if test="$Title/Fields/Rights/DisplayAsLastChance">
							<offer:DisplayAsLastChance>
								<xsl:value-of select="concat('P',$Title/Fields/Rights/DisplayAsLastChance,'D')"/>
							</offer:DisplayAsLastChance>
						</xsl:if>
					</offer:Presentation>
				</xsl:if>
			</xsl:for-each>
			
			<xsl:for-each select="$Display/Fields/Categories/Category">
				<offer:Presentation>
					<xsl:if test="Text">
						<offer:CategoryRef>
							<xsl:call-template name="encodeCategoryUri" />
						</offer:CategoryRef>
					</xsl:if>
					<xsl:if test="$Display/Fields/Rights/NewReleaseWindow">
						<offer:DisplayAsNew>
							<xsl:value-of select="concat('P',$Display/Fields/Rights/NewReleaseWindow,'D')"/>
						</offer:DisplayAsNew>
					</xsl:if>
					<xsl:if test="$Display/Fields/Rights/DisplayAsLastChance">
						<offer:DisplayAsLastChance>
							<xsl:value-of select="concat('P',$Display/Fields/Rights/DisplayAsLastChance,'D')"/>
						</offer:DisplayAsLastChance>
					</xsl:if>
				</offer:Presentation>
			</xsl:for-each>

			<offer:PromotionalContentGroupRef uriId="{$ContentGroupUriId}"/>

			<xsl:for-each select="$Package/Fields/ProviderContentTiers/ProviderContentTier">
				<offer:ProviderContentTier>
					<xsl:value-of select="Value"/>
				</offer:ProviderContentTier>
			</xsl:for-each>
			
			<xsl:if test="$Package/Fields/MetadataSpecVersion">
				<offer:SourceMetadataSpecVersion deprecated="true">
					<xsl:value-of select="$Package/Fields/MetadataSpecVersion"/>
				</offer:SourceMetadataSpecVersion>
			</xsl:if>

 			<offer:BillingId>
				<xsl:choose>
					<xsl:when test="$Title/Fields/BillingInfo/Identifier/Id">
						<xsl:value-of select="$Title/Fields/BillingInfo/Identifier/Id"/>
					</xsl:when>
					<xsl:otherwise>00000</xsl:otherwise>
				</xsl:choose>
			</offer:BillingId>
			
			<offer:TermsRef uriId="{$TermsUriId}"/>

			<!-- Check for referenced titles -->	
			<xsl:choose>
 				<xsl:when test="$Title/Fields/CustomFields/CustomField[@name='Is_PlayList']/BooleanValue = 'true'">
						<offer:ContentGroupRef>
							<xsl:call-template name="encodeUri">
								<xsl:with-param name="providerId" select="$TitleProviderId" />
								<xsl:with-param name="assetType" select="'/ContentGroup/'" />
								<xsl:with-param name="fieldId" select="$TitleAssetId" />
							</xsl:call-template>
						</offer:ContentGroupRef>		
				</xsl:when> 
				<xsl:otherwise>
					<!-- Check for referenced titles -->	
					<xsl:choose>
			   <xsl:when test="Fields/TitleGroup">
    		        <xsl:for-each select="Fields/TitleGroup">
	        		<xsl:variable name="RefTitleProviderId" select="ProviderInfo/Identifier/Id"/>
	        		<xsl:variable name="RefTitleAssetId" select="Identifier/Id"/>
		    		<xsl:if test="($RefTitleProviderId != '') and ($RefTitleAssetId != '')">		    	
		    			<offer:ContentGroupRef>
							<xsl:call-template name="encodeUri">
								<xsl:with-param name="providerId" select="$RefTitleProviderId" />
								<xsl:with-param name="assetType" select="'/ContentGroup/'" />
								<xsl:with-param name="fieldId" select="$RefTitleAssetId" />
							</xsl:call-template>
						</offer:ContentGroupRef>
					</xsl:if>
    				</xsl:for-each>
    		   </xsl:when>
    		   <xsl:otherwise>
		    		<offer:ContentGroupRef>
					    <xsl:call-template name="encodeUri">
						    <xsl:with-param name="providerId" select="$TitleProviderId" />
						    <xsl:with-param name="assetType" select="'/ContentGroup/'" />
						    <xsl:with-param name="fieldId" select="$TitleAssetId" />
					    </xsl:call-template>
				    </offer:ContentGroupRef>
    		   </xsl:otherwise>
			</xsl:choose>
				 </xsl:otherwise>
			</xsl:choose>
		</Asset>
		<xsl:if test="$Title/Fields/CustomFields/CustomField[@name='Is_PlayList']/BooleanValue = 'true'">
			<Asset xsi:type="ericsson:SegmentGroupType">
				<xsl:call-template name="encodeUri">
					<xsl:with-param name="providerId" select="$Title/Fields/ProviderInfo/Identifier/Id" />
					<xsl:with-param name="assetType" select="'/Playlist/'" />
					<xsl:with-param name="fieldId" select="$Title/Fields/Identifier/Id" />
				</xsl:call-template>
				
				<xsl:call-template name="AMS_1" />	
				<xsl:call-template name="AMS_2" />
				
				<core:Ext/>
				
				<!--  <Type>StaticPlaylist</Type> -->
				<ericsson:Type>
					<xsl:choose>
						<xsl:when test="Fields/Content/Type">						
							<xsl:value-of select="Fields/Content/Type"/>
						</xsl:when>
						<xsl:otherwise>StaticPlaylist</xsl:otherwise>
					</xsl:choose>			
				</ericsson:Type>
				
				<xsl:for-each select="/ECMFSpec/Package/Fields/TitleGroup">
					<xsl:variable name="RefTitleProviderId" select="ProviderInfo/Identifier/Id"/>
					<xsl:variable name="RefTitleAssetId" select="Identifier/Id"/>
					<xsl:if test="($RefTitleProviderId != '') and ($RefTitleAssetId != '')">
						<ericsson:SegmentRef>
							<xsl:call-template name="encodeUri">
								<xsl:with-param name="providerId" select="$RefTitleProviderId" />
								<xsl:with-param name="assetType" select="'/ContentGroup/'" />
								<xsl:with-param name="fieldId" select="$RefTitleAssetId" />
							</xsl:call-template>
							<xsl:attribute name="segmentID">
								<xsl:value-of select="concat('segment_' , $RefTitleAssetId )"/>
							</xsl:attribute>
						</ericsson:SegmentRef>
					</xsl:if>
				</xsl:for-each>
			</Asset>
		</xsl:if>	
	</xsl:template>

	<!-- Templates to convert trial use fields -->
	<xsl:template match="Fields/CustomFields/CustomField">
		<xsl:call-template name="customField">
			<xsl:with-param name="app" select="$Title/Fields/ProductInfo/Name" />
			<xsl:with-param name="name" select="@name" />
			<xsl:with-param name="value" select="Value" />
		</xsl:call-template>
	</xsl:template>

</xsl:stylesheet>
