#!/usr/bin/env python

import os
import sys
import urlparse
import shutil
import fnmatch
import errno


class FolderCopy:
    
    def __init__(self):
        self.result = None
        self.source = None
        self.destination = None
        self.filter="*"
    
    def getResult(self):
        return self.result
        
    def copyFolder (self, source, destination, filter):
        
        #print "source: " + source + " destination: " + destination + " filter: "+ filter
        if not os.path.isdir(source):
            self.result = "Error: File patch: "+ source + " is not a directory"
            print self.result
            return
            
        destination = os.path.abspath(destination)
        source = os.path.abspath(source)
        if destination.startswith(source):
            self.result = "Error: Destination can not be same as source or a sub folder of source."
            print self.result
            return

        try:
            if not os.path.exists(destination):
                self.mkdir_p(destination)
                #os.chmod(destination, 0777)
            for path, dirs, files in os.walk(source):
                for dir in fnmatch.filter(dirs, filter):
                    dirpath = os.path.join(path, dir)
                    saveDirpath = self.getTargetFilePath(source, destination,dirpath)
                    if not os.path.exists(saveDirpath):
                        self.mkdir_p(saveDirpath)
                        shutil.copymode(dirpath, saveDirpath)
                        #os.chmod(saveDirpath, 0777)
                for filename in fnmatch.filter(files, filter):
                    filepath = os.path.join(path, filename)
                    finalFilepath = self.getTargetFilePath(source, destination, filepath)
                    shutil.copyfile(filepath, finalFilepath)
                    shutil.copymode(filepath, finalFilepath)
                    #os.chmod(finalFilepath, 0777)
        except Exception, e:
            excType = e.__class__.__name__
            self.result = excType+ ": "+str(e)
        else:
            self.result = "Successful"
            
        print self.result

    def mkdir_p(self, path):
        """ 'mkdir -p' in Python """
        try:
            os.makedirs(path)
        except OSError as exc:  # Python >2.5
            if exc.errno == errno.EEXIST and os.path.isdir(path):
                pass
            else:
                raise

    def getTargetFilePath(self, source, destination, filepath): 
        return destination + filepath[filepath.index(source)+len(source):]
    
    def validateParameters(self):  
        if self.source is None or self.source == "":
            self.result = "Error: source parameter is mandatory"
            print self.result
            return False
            
        if self.destination is None or self.destination == "":
            self.result = "Error: destination parameter is mandatory"
            print self.result
            return False        
        return True  
    
    def parseURL(self,url):

        parsed = urlparse.urlparse(url)
        
        if urlparse.parse_qs(parsed.query).has_key('source'):
           self.source = urlparse.parse_qs(parsed.query)['source'].pop()
           
        if urlparse.parse_qs(parsed.query).has_key('destination'):
            self.destination = urlparse.parse_qs(parsed.query)['destination'].pop()
        
        if urlparse.parse_qs(parsed.query).has_key('filter'):
            self.filter = urlparse.parse_qs(parsed.query)['filter'].pop()
            if self.filter == "":
                self.filter = "*"
        return (self.source, self.destination, self.filter)
    
def main():
        print "Content-type: text/plain; charset=utf-8\n\n";
        if len(sys.argv) < 2:
            print "Error: passed arguments to FolderCopy cgi script are not corect"
            exit(-1)
        #url = os.environ["REQUEST_URI"]
        '''sys.arg[0] is FolderCopy.py'''        
        url = sys.argv[1]
        
        #print os.geteuid()
        #print os.getegid()
        
        folderCopy=FolderCopy()
        
        source, destination, filter = folderCopy.parseURL(url)
                
        isParaValid = folderCopy.validateParameters()
        if isParaValid:
            folderCopy.copyFolder(source, destination, filter)

if __name__ == "__main__":
        main()