#!/bin/bash
set -e
SCRIPTNAME=$(basename $0 .sh)


CMSVersion=$(cat /opt/tandbergtv/cms/product.properties | grep product.version | awk -F '=' '{print $2}' | cut -c -1 | bc)
echo "$SCRIPTNAME: Running script on ${CMSVersion}.x cms"
if [[ $CMSVersion -ge 6 ]];
then
    PSQLCMD='/usr/pgsql-9.5/bin/psql'
else
    PSQLCMD='/opt/PostgresPlus/9.3AS/bin/psql'
fi

ALLLOCKS=($(PGPASSWORD=Wf\$1234 $PSQLCMD -p 5444 -h dbserver -U wfs -d ttv -c 'select key from distributed_cacheinfo where type=2' | head -n -2 | tail -n+3))

numberOfLocks=${#ALLLOCKS[@]}
echo "$SCRIPTNAME: Totally $numberOfLocks locks in database"

#$(PGPASSWORD=Wf\$1234 $PSQLCMD -p 5444 -h dbserver -U wfs -d ttv -c 'delete from distributed_cacheinfo where type=2; commit;' | head -n -2 | tail -n+3)
for((i=0;i<$numberOfLocks;i++))
do
   lockname=${ALLLOCKS[$i]}
   echo "$SCRIPTNAME: Trying to release lock '${lockname}'"
   curl -XDELETE -s http://localhost:5722/hazelcast/rest/maps/WFLockInfo/${lockname}
done
