CREATE OR REPLACE VIEW wfs.VDW_PREPACK_PURGE_REPORTS AS 
SELECT DISTINCT rti.title_brief AS title_brief, 
       rti.provider_id AS provider_id, 
       ptnr.name AS provider_name, 
       to_date(SUBSTR(rti.license_start_date, 1, 10), 'yyyy-MM-dd') AS License_start_date, 
       to_date(SUBSTR(rti.license_end_date, 1, 10), 'yyyy-MM-dd') AS License_end_date, 
       rti.asset_count AS asset_count, rti.pkg_asset_id AS package_asset_id, 
       pis.operationalprocessstatusid AS work_order_status_id, 
       CASE WHEN ps.name ='STOPPED' THEN 'COMPLETE' WHEN ps.name ='ERROR' THEN 'FAIL' ELSE ps.name END AS work_order_status, 
       pi.isactive AS is_work_order_active, 
       pd.name_ AS template_name, 
       TO_CHAR(pi.start_,'mm/dd/yyyy hh24:mi:ss') AS wo_start_datetime, 
       to_date(TO_CHAR(pi.start_,'yyyy-mm-dd'),'yyyy-mm-dd') AS wo_start, 
       to_date(TO_CHAR(pi.end_ ,'yyyy-mm-dd'),'yyyy-mm-dd') AS wo_end, 
       to_char(extract(day from pis.end_ - pi.start_), '0000') || to_char(pis.end_ - pi.start_,' HH24:MI:SS') AS work_order_time, 
       1 AS Provider_Title_Cnt, rti.site_name As site_name, 
       rti.title_id AS title_id 
  FROM wfs.jbpm_processinstance pi 
  LEFT OUTER JOIN wfs.Prepack_Report_TitleInfo rti ON (rti.workorder_id = pi.id_) 
  JOIN wfs.jbpm_processinstance pis on (rti.final_workorder_id = pis.id_) 
  JOIN wfs.pmm_partner ptnr ON (ptnr.providerid = rti.provider_id) 
  JOIN wfs.jbpm_processdefinition pd ON (pd.id_ = pi.processdefinition_) 
  JOIN ttv_processstatus ps ON (pis.operationalprocessstatusid = ps.processstatusid);  