#!/bin/bash
#Copyright (c) 2017 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Jacky
# Created: May 31, 2017
# Description:
# Use Shell to do additional jobs after installation is done, mainly for upgrading.
#
#

echo 'Start: POST INSTALLATION... '

echo 'Delete the unused .ce files under folder /content/data.'
find /content/data  -type f  -name "*.ce" -delete

echo 'Update allocation strategy of fabrix-additional resource group.'
sed -i 's/com.ericsson.workflow.resourcemanager.mgmt.allocation.ResourceNameBaseAllocationStrategy/com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultKeyBasedAllocationStrategy/' /opt/tandbergtv/cms/workflow/plugins/groups/fabrix-additional/plugin.xml

echo 'Update ip address for fabrix-task-monitoring and fabrix-secondary-task-monitoring'
FABRIX_IP=$(cat /etc/hosts | grep '\bfabrix$' | awk '{print $1}')
if [ ! -z $FABRIX_IP ]; then
    sed -i "/fabrix-task-monitoring/c $FABRIX_IP\tfabrix-task-monitoring" /etc/hosts
else
    echo '[WARNING] "fabrix" host name is not configured in /etc/hosts, please run "list-installed-components.sh" to check if Fabrix component is installed. Ignore this warning if the component is not installed, Otherwise, manually update ip address for fabrix-task-monitoring is required!'
fi

FABRIX_SECONDARY_IP=$(cat /etc/hosts | grep '\bfabrix-secondary$' | awk '{print $1}')
if [ ! -z $FABRIX_SECONDARY_IP ]; then
    sed -i "/fabrix-secondary-task-monitoring/c $FABRIX_SECONDARY_IP\tfabrix-secondary-task-monitoring" /etc/hosts
else
    echo '[WARNING] "fabrix-secondary" host name is not configured in /etc/hosts, please run "list-installed-components.sh" to check if Charter component is installed. Ignore this warning if the component is not installed, Otherwise, manually update ip address for fabrix-secondary-task-monitoring is required!'
fi

echo 'Done: POST INSTALLATION...'
