create or replace view wfs.title_distribution_info as
	(SELECT distinct rti.provider_id as provider_id, 
		ptnr.name as provider_name, 
		rti.document_id as document_id,
		rti.title_brief as title_brief,
		REPLACE(rti.license_start_date, 'T', ' ') as License_start_date,
		REPLACE(rti.license_end_date, 'T', ' ') as License_end_date, 
		rti.pkg_asset_id as Package_AssetID,
		rti.asset_count as asset_count,
		'Media Transcoded' as wo_status, 
		to_date(to_char(pi.start_,'yyyy-mm-dd'),'yyyy-mm-dd') as wo_start,
		to_date(to_char(pi.end_ ,'yyyy-mm-dd'),'yyyy-mm-dd') as wo_end,
		to_char(extract(day from pi.end_ - pi.start_), '0000') || to_char(pi.end_ - pi.start_,' HH24:MI:SS') completion_time,
		round(extract(second from (pi.end_ - pi.start_)) + extract(minute from (pi.end_ - pi.start_))*60 + extract(hour from (pi.end_ - pi.start_))*60*60 + extract(day from (pi.end_ - pi.start_))*60*60*24) as completion_time_seconds  	 
	FROM wfs.Prepack_Report_TitleInfo rti, 
		wfs.pmm_partner ptnr,
		wfs.ttv_processstatus ps,
		wfs.jbpm_processinstance pi, 
		wfs.jbpm_processdefinition pd            
	where rti.workorder_id = pi.id_
		and ptnr.providerid = rti.provider_id
		and pi.operationalprocessstatusid = ps.processstatusid 
		and pd.id_ = pi.processdefinition_
		and pd.name_='Azuki Distribution Template') 
 union all 
	 (SELECT distinct rti.provider_id as provider_id, 
		 ptnr.name as provider_name, 
		 rti.document_id as document_id, 
		 rti.title_brief as title_brief, 
		 REPLACE(rti.license_start_date,'T',' ') as License_start_date, 
		 REPLACE(rti.license_end_date, 'T', ' ') as License_end_date, 
		 rti.pkg_asset_id as Package_AssetID, 
		 rti.asset_count as asset_count,      
		 'Media Transcoded' as wo_status,           
		 to_date(to_char(pi.start_,'yyyy-mm-dd'),'yyyy-mm-dd') as wo_start,           
		 to_date(to_char(pi.end_ ,'yyyy-mm-dd'),'yyyy-mm-dd') as wo_end,
		 to_char(extract(day from pi.end_ - pi.start_), '0000') || to_char(pi.end_ - pi.start_,' HH24:MI:SS') completion_time,
		 round(extract(second from (pi.end_ - pi.start_)) + extract(minute from (pi.end_ - pi.start_))*60 + extract(hour from (pi.end_ - pi.start_))*60*60 + extract(day from (pi.end_ - pi.start_))*60*60*24) as completion_time_seconds          	 
	 FROM wfs.Prepack_Report_TitleInfo rti, 
		 wfs.pmm_partner ptnr,
		 wfs.ttv_processstatus ps,
		 wfs.jbpm_processinstance pi,
		 wfs.jbpm_processinstance pis,
		 wfs.jbpm_processdefinition pd 	        
	 where rti.workorder_id = pis.id_ 
		 and pis.roottoken_ = pi.superprocesstoken_ 
		 and ptnr.providerid = rti.provider_id 
		 and pi.operationalprocessstatusid = ps.processstatusid
		 and pd.id_ = pi.processdefinition_      
		 and pd.name_='Distribute Metadata to Azuki')
		 