'''
Created on Sep 11, 2014

@author: Simon Meng
'''
import json
import os
from distutils.dir_util import copy_tree
from distutils.dir_util import remove_tree
from distutils.file_util import copy_file

#Define the system directory to avoid deleted accidentally
sysdirs = ['/bin','/boot','/cgroup','/content','/dev','/etc','/home','/lib','/lib64','/media',
           '/mnt','/opt','/proc','/root','/sbin','/selinux','/srv','/sys','/tmp','/usr','/var']

class SyncFiles(object):
    
    def __init__(self, ):
        self.filesyn_dir = '/opt/tandbergtv/cms/prepack/filesync/files'
        self.jsonconf = dict()
        self.__loadconf()
        
    def __loadconf(self):
        conffile = self.filesyn_dir + os.sep + 'sync-config.json'
        fileobj = open(conffile)
        self.jsonconf = json.load(fileobj)
        fileobj.close()
        
    def syncfiles(self):
        '''
        Sync files according to the configure
        '''
        #replace files 
        if self.jsonconf.has_key('files'):
            for path in self.jsonconf['files']:
                if not os.path.exists(self.filesyn_dir + path):
                    raise RuntimeError('The sync file does not exist,' + self.filesyn_dir + path)
                #TODO, backup files
                print 'sync files:' + path + ' from ' + self.filesyn_dir + path
                self.__rmdirOrfile(path)
                self.__copyto(self.filesyn_dir + path, path)
             
        #delete files    
        if self.jsonconf.has_key('files_delete'):
            for path in self.jsonconf['files_delete']:
                print 'delete file or dir:' , path
                self.__rmdirOrfile(path)
                
        #handle symbolic link
        if self.jsonconf.has_key('symbolicLinks'):
            for link in self.jsonconf['symbolicLinks']:
                linkTo = link['linkTo']
                linkName = link['linkName']
                if os.path.exists(linkTo):
                    if not os.path.isdir(linkName):
                        print 'directory ' + linkName + ' exists'
                    if not os.path.exists(linkName):
                        parent = os.path.dirname(linkName)
                        if not os.path.exists(parent):
                            os.mkdir(parent)
                        os.symlink(linkTo, linkName)
                    
    
        # Remount a subtree somewhere else      
        if self.jsonconf.has_key('shared_mountpoints'):
              for mp in self.jsonconf['shared_mountpoints']:
                  if os.path.ismount(mp["newdir"]):
                      continue
                  if not os.path.exists(mp["newdir"]):
                      os.makedirs(mp["newdir"])
                  os.popen("mount --bind %s  %s" % (mp["olddir"], mp["newdir"]), "r")
                
        #change file owner?
        #TODO: ?
        
    def __rmdirOrfile(self,filepath):
        #make sure not delete the system directory
        if filepath not in sysdirs and os.path.exists(filepath):
            if os.path.isdir(filepath):
                remove_tree(filepath)
            else:
                os.remove(filepath)
        
    def __copyto(self, srcpath, distpath):
        if os.path.exists(srcpath):
            if os.path.isdir(srcpath) or os.path.isfile(srcpath):
                parent = os.path.dirname(distpath)
                if not os.path.isdir(parent):
                    os.makedirs(parent)
                
                # use shell command directly to retain the ownership of files
                cp_cmd = 'cp -rp "%s" "%s"' % (srcpath, distpath)
                os.popen(cp_cmd)
            else:
                #ignore symblic link
                print 'symblic link' + srcpath
                pass

if __name__ == '__main__':
    SyncFiles().syncfiles()