#!/bin/bash
#
# Copyright (c) 2013 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Simon Meng
# Created: Jul 26, 2013
# Description:
# A script for install/update cms cron job(s)

echo "Install cron job begin..."


datestamp=`date '+%Y%m%d%H%M%S'`

HOUSEKEEP_CRON_EXP="0 0 * * *"
HOUSEKEEP_CMD=cms-file-housekeep.sh
HOUSEKEEP_CMD_PATH=/opt/tandbergtv/cms/cronjob/cms-file-housekeep.sh


chown nobody:nobody $HOUSEKEEP_CMD_PATH
chmod +x $HOUSEKEEP_CMD_PATH
crontab -u nobody -l > /tmp/cron.${datestamp}
cp /tmp/cron.${datestamp} /tmp/cron.${datestamp}.bak

sed -i "s/.*${HOUSEKEEP_CMD}.*//g"  /tmp/cron.${datestamp}
sed -i '/^$/d' /tmp/cron.${datestamp}
echo "${HOUSEKEEP_CRON_EXP} ${HOUSEKEEP_CMD_PATH}" >> /tmp/cron.${datestamp}

crontab -u nobody /tmp/cron.${datestamp}

echo "Install cron job done"

exit;
