#!/usr/bin/env python
# Name:    extractfile-cgi
# Notes:   Extract tar file
#
import tarfile
import os
import urlparse
import sys

class ExtractFile:

        def extract(self, sourceFile, destDir):
            tar= tarfile.open(sourceFile, "r:")
            tar.extractall(path = destDir)
            tar.close()
            print "Extract tar file successfully."

        def parseURL(self, url):
            parsed = urlparse.urlparse(url)

            if urlparse.parse_qs(parsed.query).has_key('sourcefile'):
                sourcefile = urlparse.parse_qs(parsed.query)['sourcefile'].pop()

            if urlparse.parse_qs(parsed.query).has_key('destdir'):
                destdir = urlparse.parse_qs(parsed.query)['destdir'].pop()
            return (sourcefile, destdir)

        def validatePara(self, sourceFile, destDir):

            if not os.path.exists(destDir) or not os.path.isdir(destDir):
                raise Exception('Destination folder is not exist or is not directory: ' + destDir)

            if not os.path.exists(sourceFile) or not os.path.isfile(sourceFile):
                raise Exception('Source file is not exist or is not file: ' + sourceFile)

def main():
        print 'Content-type: text/plain; charset=utf-8\n\n'
        if len(sys.argv) < 2:
            print "Error: passed arguments to extractfile cgi script are not correct"
            exit(-1)
        '''sys.arg[0] is extractfile.py'''
        url = sys.argv[1]

        extractFile = ExtractFile()
        sourceFile, destDir = extractFile.parseURL(url)
        try:
            extractFile.validatePara(sourceFile, destDir)
            extractFile.extract(sourceFile, destDir)
        except Exception, e:
            print "ERROR: Extract file failed."
            print e

if __name__ == "__main__":
        main()
