<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" version="2.0" exclude-result-prefixes="xs xsi">
	<xsl:import href="from/title.xsl"/>
	<xsl:import href="from/movie.xsl"/>
	
	<xsl:output method="xml" indent="yes" encoding="utf-8" omit-xml-declaration="yes" />
	
	<xsl:variable name="Package" select="/ECMFSpec/Package"/>
	<xsl:variable name="PackageProviderId" select="$Package/Fields/ProviderInfo/Identifier/Id"/>
	<xsl:variable name="PackageAssetId" select="$Package/Fields/Identifier/Id"/>
	<xsl:variable name="Title" select="$Package/Title"/>
	<xsl:variable name="Movie" select="$Package/Movie"/>
	
	<xsl:template match="/">
		<media>
			<xsl:apply-templates select="$Title" />
			<xsl:apply-templates select="$Movie"/>
		</media>
	</xsl:template>
</xsl:stylesheet>