<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:cmsut="http://www.ericsson.com/cms/utility" version="2.0"
	exclude-result-prefixes="xs xsi cmsut">
	<xsl:import href="from/utility.xsl" />
	<xsl:variable name="runTime" select="$Title/Fields/Duration/Duration" />

	<xsl:template match="/ECMFSpec/Package/Movie">
		<xsl:if test="not(Fields/CustomFields/CustomField[@name='Platform'])">
			<markers>
				<xsl:apply-templates select="Fields/Avails/Avail" />
			</markers>
		</xsl:if>
	</xsl:template>

	<xsl:template match="Fields/Avails/Avail">
		<xsl:choose>
			<xsl:when test="TimeCodeTwo">
				<marker>
					<xsl:element name="start_offset">
						<xsl:variable name="timcode2" select="TimeCodeTwo" />
						<xsl:call-template name="convertAvilTimeCode">
							<xsl:with-param name="timecode" select="$timcode2" />
						</xsl:call-template>
					</xsl:element>
					<xsl:call-template name="AvailOtherFields" />
				</marker>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="curAvilInd" select="position()" />
				<xsl:apply-templates
					select="../../../UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeTwo']">
					<xsl:with-param name="index" select="string($curAvilInd)" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="AvailOtherFields">
		<xsl:element name="duration">
			<xsl:value-of select="60*1000" />
		</xsl:element>
		<xsl:element name="marker_type">
			<xsl:value-of select="Type" />
		</xsl:element>
		<xsl:element name="marker_data">
			<xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
			<xsl:value-of select="Position" />
			<xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
		</xsl:element>
	</xsl:template>

	<xsl:template
		match="UnparsableFields/UnparsableField[@xpath='/Fields/Avails/Avail/TimeCodeTwo']">
		<xsl:param name="index" />
		<xsl:variable name="indices" select="@indices" />
		<xsl:variable name="indList" select="tokenize($indices, '\s*,')" />
		<xsl:variable name="curIndex" select="$indList[3]" />
		<xsl:if test="$curIndex=$index">
			<marker>
				<xsl:element name="start_offset">
					<xsl:call-template name="convertAvilTimeCode">
						<xsl:with-param name="timecode" select="@value" />
					</xsl:call-template>
				</xsl:element>

				<xsl:apply-templates select="../../Fields/Avails/Avail"
					mode="AvailOtherFields">
					<xsl:with-param name="index" select="$curIndex" />
				</xsl:apply-templates>
			</marker>
		</xsl:if>
	</xsl:template>

	<xsl:template match="Fields/Avails/Avail" mode="AvailOtherFields">
		<xsl:param name="index" />
		<xsl:if test="$index=string(position())">
			<xsl:call-template name="AvailOtherFields" />
		</xsl:if>
	</xsl:template>

	<xsl:template name="convertAvilTimeCode">
		<xsl:param name="timecode" />
		<xsl:choose>
			<xsl:when test="upper-case($timecode)='BOS'">
				<xsl:value-of select="0" />
			</xsl:when>
			<xsl:when test="upper-case($timecode)='EOS'">
				<xsl:value-of select="cmsut:convertRunTimeToAzukiFormat($runTime)" />
			</xsl:when>
			<xsl:when test="($timecode castable as xs:decimal)">
				<xsl:value-of select="($timecode idiv 1)*1000" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="cmsut:convertTimeCodeToAzukiFormat($timecode)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
