<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">

	<xsl:import href="from/common.xsl"/>
	<xsl:import href="from/advertisement.xsl"/>
	
	<xsl:template match="/ECMFSpec/Package/Title">
		<xsl:call-template name="Title"/>
		<xsl:call-template name="Advertisement"/>
		<xsl:call-template name="ContentGroup"/>
		<xsl:call-template name="Terms"/>
		<xsl:call-template name="Category"/>
	</xsl:template>
	
	<xsl:template name="Title">
		<Asset xsi:type="title:TitleType">
			<xsl:attribute name="uriId"><xsl:value-of select="$TitleUriId"/></xsl:attribute>
			<xsl:call-template name="AMS_1" />
			<xsl:if test="Fields/ISAN">
				<core:AlternateId identifierSystem="ISAN">
					<xsl:value-of select="Fields/ISAN"/>
				</core:AlternateId>
			</xsl:if>
			<xsl:if test="Fields/ProviderQAContact/Value">
				<core:ProviderQAContact>
					<xsl:value-of select="Fields/ProviderQAContact/Value"/>
				</core:ProviderQAContact>
			</xsl:if>
			<xsl:call-template name="AMS_2" />
			
			<core:Ext>
				<xsl:if test="Fields/OSVOD/AssociationIds/AssociationId or Fields/TSTV/ChannelId or Fields/Rights/LicensingWindowStart or Fields/TSTV/EndTime or Fields/TSTV/RecordPriority or Fields/TSTV/ProgramName or Fields/TSTV/ProgramId or Fields/TSTV/Repeat or Fields/Rights/Contract/Id or Fields/CreationInfo/Place/Region or Fields/TSTV/PlaybackWindows or Fields/TSTV/MaxCopies or Fields/TSTV/DeleteTime or Fields/TSTV/RefCount or Fields/TSTV/CatalogEntry or Fields/TSTV/PurgeTime or Fields/TvId/SeriesId or Fields/ContentType or Fields/TvId/EpisodeSeasonNumber">
					<ericsson:TitleExt>
						<xsl:if test="Fields/OSVOD/AssociationIds/AssociationId">
							<ericsson:AssociationId>
								<xsl:value-of select="Fields/OSVOD/AssociationIds/AssociationId"/>
							</ericsson:AssociationId>
						</xsl:if>
						<xsl:if test="Fields/TSTV/ChannelId">
							<ericsson:ChannelId>
								<xsl:value-of select="Fields/TSTV/ChannelId"/>
							</ericsson:ChannelId>
						</xsl:if>
						<xsl:if test="Fields/Rights/LicensingWindowStart">
							<ericsson:StartTime>
								<xsl:value-of select="Fields/Rights/LicensingWindowStart"/>
							</ericsson:StartTime>
						</xsl:if>
						<xsl:if test="Fields/TSTV/EndTime">
							<ericsson:EndTime>
								<xsl:value-of select="Fields/TSTV/EndTime"/>
							</ericsson:EndTime>
						</xsl:if>
						<xsl:if test="Fields/TSTV/RecordPriority">
							<ericsson:RecordPriority>
								<xsl:value-of select="Fields/TSTV/RecordPriority"/>
							</ericsson:RecordPriority>
						</xsl:if>
						<xsl:if test="Fields/TSTV/ProgramName">
							<ericsson:ProgramName>
								<xsl:value-of select="Fields/TSTV/ProgramName"/>
							</ericsson:ProgramName>
						</xsl:if>
						<xsl:if test="Fields/TSTV/ProgramId">
							<ericsson:ProgramId>
								<xsl:value-of select="Fields/TSTV/ProgramId"/>
							</ericsson:ProgramId>
						</xsl:if>
						<xsl:if test="Fields/TSTV/Repeat">
							<ericsson:Repeat>
								<xsl:value-of select="Fields/TSTV/Repeat"/>
							</ericsson:Repeat>
						</xsl:if>
						<xsl:if test="Fields/Rights/Contract/Id">
							<ericsson:ContractId>
								<xsl:value-of select="Fields/Rights/Contract/Id"/>
							</ericsson:ContractId>
						</xsl:if>
						<xsl:if test="Fields/CreationInfo/Place/Region">
							<ericsson:RecordingRegion>
								<xsl:value-of select="Fields/CreationInfo/Place/Region"/>
							</ericsson:RecordingRegion>
						</xsl:if>
						<xsl:if test="Fields/TSTV/PlaybackWindows">
							<ericsson:PlaybackWindows>
								<xsl:value-of select="Fields/TSTV/PlaybackWindows"/>
							</ericsson:PlaybackWindows>
						</xsl:if>
						<xsl:if test="Fields/TSTV/MaxCopies">
							<ericsson:MaxCopies>
								<xsl:value-of select="Fields/TSTV/MaxCopies"/>
							</ericsson:MaxCopies>
						</xsl:if>
						<xsl:if test="Fields/TSTV/DeleteTime">
							<ericsson:DeleteTime>
								<xsl:value-of select="Fields/TSTV/DeleteTime"/>
							</ericsson:DeleteTime>
						</xsl:if>
						<xsl:if test="Fields/TSTV/RefCount">
							<ericsson:RefCount>
								<xsl:value-of select="Fields/TSTV/RefCount"/>
							</ericsson:RefCount>
						</xsl:if>
						<xsl:if test="Fields/TSTV/CatalogEntry">
							<ericsson:CatalogEntry>
								<xsl:value-of select="Fields/TSTV/CatalogEntry"/>
							</ericsson:CatalogEntry>
						</xsl:if>
						<xsl:if test="Fields/TSTV/PurgeTime">
							<ericsson:PurgeTime>
								<xsl:value-of select="Fields/TSTV/PurgeTime"/>
							</ericsson:PurgeTime>
						</xsl:if>
						<xsl:if test="Fields/TvId/SeriesId">
							<ericsson:SeriesId>
								<xsl:value-of select="Fields/TvId/SeriesId"/>
							</ericsson:SeriesId>
						</xsl:if>
						<xsl:if test="Fields/ContentType">
							<ericsson:ContentType>
								<xsl:value-of select="Fields/ContentType"/>
							</ericsson:ContentType>
						</xsl:if>
						<xsl:if test="Fields/TvId/EpisodeSeasonNumber">
							<ericsson:SeasonNumber>
								<xsl:value-of select="Fields/TvId/EpisodeSeasonNumber"/>
							</ericsson:SeasonNumber>
						</xsl:if>
					</ericsson:TitleExt>
				</xsl:if>
				<xsl:apply-templates select="Fields/CustomFields/CustomField" />
			</core:Ext>

			<xsl:for-each select="$Title">
			<title:LocalizableTitle>
				<xsl:if test="Fields/Title/DisplayTitle/Language/@value">
					<xsl:attribute name="xml:lang"><xsl:value-of select="Fields/Title/DisplayTitle/Language/@value"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="Fields/Title/SortTitle/Value">
					<title:TitleSortName>
						<xsl:value-of select="Fields/Title/SortTitle/Value"/>
					</title:TitleSortName>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Fields/Title/ShortTitle/Value">
						<title:TitleBrief>
							<xsl:value-of select="substring(Fields/Title/ShortTitle/Value,1,19)"/>
						</title:TitleBrief>
						<title:TitleMedium>
							<xsl:value-of select="substring(Fields/Title/ShortTitle/Value,1,35)"/>
						</title:TitleMedium>
					</xsl:when>		
					<xsl:otherwise>
						<title:TitleBrief>
							<xsl:value-of select="substring(Fields/Title/DisplayTitle/Value,1,19)"/>
						</title:TitleBrief>
						<title:TitleMedium>
							<xsl:value-of select="substring(Fields/Title/DisplayTitle/Value,1,35)"/>
						</title:TitleMedium>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="Fields/Title/DisplayTitle/Value">
					<title:TitleLong>
						<xsl:value-of select="Fields/Title/DisplayTitle/Value"/>
					</title:TitleLong>
				</xsl:if>
				<xsl:if test="Fields/Summary/ShortSummary/Value">
					<title:SummaryShort>
						<xsl:value-of select="Fields/Summary/ShortSummary/Value"/>
					</title:SummaryShort>
				</xsl:if>
				<xsl:if test="Fields/Summary/MediumSummary/Value">
					<title:SummaryMedium>
						<xsl:value-of select="Fields/Summary/MediumSummary/Value"/>
					</title:SummaryMedium>
				</xsl:if>
				<xsl:if test="Fields/Summary/DisplaySummary/Value">
					<title:SummaryLong>
						<xsl:value-of select="Fields/Summary/DisplaySummary/Value"/>
					</title:SummaryLong>
				</xsl:if>
				<xsl:if test="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'ACTOR']">
					<title:ActorDisplay>
						<xsl:for-each select="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'ACTOR' and normalize-space(../LastName/.) ='' and normalize-space(../FirstName/.) = ''] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:ActorDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/Sources/Source/Contact[../Role/Name = 'ACTOR']">		
					<xsl:if test="normalize-space(FirstName/.) != '' or normalize-space(LastName/.) != ''">
						<title:Actor>
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(DisplayName/.) != ''">
										<xsl:value-of select="DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="concat(FirstName/., ' ', LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
											<xsl:value-of select="FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:attribute name="firstName">
								<xsl:if test="normalize-space(FirstName/.) != ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
							
							
							<xsl:if test="normalize-space(LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="concat(LastName/., ', ', FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</title:Actor>
					</xsl:if>
				</xsl:for-each>
				
				<xsl:if test="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'WRITER']">
					<title:WriterDisplay>
						<xsl:for-each select="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'WRITER' and normalize-space(../LastName/.) = '' and normalize-space(../FirstName/.) = ''] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:WriterDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/Sources/Source/Contact[../Role/Name = 'WRITER'] ">
					<xsl:if test="normalize-space(FirstName/.) != '' or normalize-space(LastName/.) != ''">
						<title:Writer>
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(DisplayName/.) != ''">
										<xsl:value-of select="DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="concat(FirstName/., ' ', LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
											<xsl:value-of select="FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:attribute name="firstName">
								<xsl:if test="normalize-space(FirstName/.) != ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
							
							<xsl:if test="normalize-space(LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="concat(LastName/., ', ', FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</title:Writer>
					</xsl:if>
				</xsl:for-each>

				<xsl:if test="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'DIRECTOR']">
					<title:DirectorDisplay>
						<xsl:for-each select="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'DIRECTOR' and normalize-space(../LastName/.) = '' and normalize-space(../FirstName/.) = ''] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:DirectorDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/Sources/Source/Contact[../Role/Name = 'DIRECTOR'] ">
					<xsl:if test="normalize-space(FirstName/.) != '' or normalize-space(LastName/.) != '' ">				
						<title:Director>
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(DisplayName/.) != ''">
										<xsl:value-of select="DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="concat(FirstName/., ' ', LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
											<xsl:value-of select="FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:attribute name="firstName">
								<xsl:if test="normalize-space(FirstName/.) != ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
							
							<xsl:if test="normalize-space(LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="concat(LastName/., ', ', FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</title:Director>
					</xsl:if>
				</xsl:for-each>

				<xsl:if test="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'PRODUCER']">
					<title:ProducerDisplay>
						<xsl:for-each select="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'PRODUCER' and normalize-space(../LastName/.) = '' and normalize-space(../FirstName/.) = ''] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:ProducerDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/Sources/Source/Contact[../Role/Name = 'PRODUCER'] ">
					<xsl:if test="normalize-space(FirstName/.) != '' or normalize-space(LastName/.) != '' ">
						<title:Producer>
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(DisplayName/.) != ''">
										<xsl:value-of select="DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="concat(FirstName/., ' ', LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
											<xsl:value-of select="FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:attribute name="firstName">
								<xsl:if test="normalize-space(FirstName/.) != ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
							
							<xsl:if test="normalize-space(LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="concat(LastName/., ', ', FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</title:Producer>
					</xsl:if>
				</xsl:for-each>

				<xsl:if test="Fields/CreationInfo/Studio/DisplayName">
					<title:StudioDisplay>
						<xsl:value-of select="Fields/CreationInfo/Studio/DisplayName"/>
					</title:StudioDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/TitleArtist">
					<title:RecordingArtist>
						<xsl:value-of select="."/>
					</title:RecordingArtist>
				</xsl:for-each>
				<xsl:for-each select="Fields/TitleArtist">
					<title:RecordingArtistDisplay>
						<xsl:value-of select="."/>
					</title:RecordingArtistDisplay>
				</xsl:for-each>
				<xsl:for-each select="Fields/SongTitle">
					<title:SongTitle>
						<xsl:value-of select="."/>
					</title:SongTitle>
				</xsl:for-each>

				<xsl:if test="Fields/Episode/Name/Value">
					<title:EpisodeName deprecated="true">
						<xsl:value-of select="Fields/Episode/Name/Value"/>
					</title:EpisodeName>
				</xsl:if>
				<xsl:if test="Fields/Episode/Number">
					<title:EpisodeID deprecated="true">
						<xsl:value-of select="Fields/Episode/Number"/>
					</title:EpisodeID>
				</xsl:if>
				<xsl:for-each select="Fields/Chapters/Chapter">
					<title:Chapter>
						<xsl:attribute name="heading">
							<xsl:value-of select="substring-after(., ',')"/>
						</xsl:attribute>	
						<xsl:attribute name="timeCode">
							<xsl:value-of select="substring-before(., ',')"/>
						</xsl:attribute>
					</title:Chapter>
				</xsl:for-each>
			</title:LocalizableTitle>
			</xsl:for-each>
			
			<xsl:for-each select="$Display">
			<title:LocalizableTitle>
				<xsl:if test="Fields/Title/DisplayTitle/Language/@value">
					<xsl:attribute name="xml:lang"><xsl:value-of select="Fields/Title/DisplayTitle/Language/@value"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="Fields/Title/SortTitle/Value">
					<title:TitleSortName>
						<xsl:value-of select="Fields/Title/SortTitle/Value"/>
					</title:TitleSortName>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Fields/Title/ShortTitle/Value">
						<title:TitleBrief>
							<xsl:value-of select="substring(Fields/Title/ShortTitle/Value,1,19)"/>
						</title:TitleBrief>
						<title:TitleMedium>
							<xsl:value-of select="substring(Fields/Title/ShortTitle/Value,1,35)"/>
						</title:TitleMedium>
					</xsl:when>		
					<xsl:otherwise>
						<title:TitleBrief>
							<xsl:value-of select="substring(Fields/Title/DisplayTitle/Value,1,19)"/>
						</title:TitleBrief>
						<title:TitleMedium>
							<xsl:value-of select="substring(Fields/Title/DisplayTitle/Value,1,35)"/>
						</title:TitleMedium>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="Fields/Title/DisplayTitle/Value">
					<title:TitleLong>
						<xsl:value-of select="Fields/Title/DisplayTitle/Value"/>
					</title:TitleLong>
				</xsl:if>
				<xsl:if test="Fields/Summary/ShortSummary/Value">
					<title:SummaryShort>
						<xsl:value-of select="Fields/Summary/ShortSummary/Value"/>
					</title:SummaryShort>
				</xsl:if>
				<xsl:if test="Fields/Summary/MediumSummary/Value">
					<title:SummaryMedium>
						<xsl:value-of select="Fields/Summary/MediumSummary/Value"/>
					</title:SummaryMedium>
				</xsl:if>
				<xsl:if test="Fields/Summary/DisplaySummary/Value">
					<title:SummaryLong>
						<xsl:value-of select="Fields/Summary/DisplaySummary/Value"/>
					</title:SummaryLong>
				</xsl:if>
				<xsl:if test="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'ACTOR']">
					<title:ActorDisplay>
						<xsl:for-each select="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'ACTOR' and normalize-space(../LastName/.) = '' and normalize-space(../FirstName/.) = ''] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:ActorDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/Sources/Source/Contact[../Role/Name = 'ACTOR']">
					<xsl:if test="normalize-space(FirstName/.) != '' or normalize-space(LastName/.) != ''">
						<title:Actor>
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(DisplayName/.) != ''">
										<xsl:value-of select="DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="concat(FirstName/., ' ', LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
											<xsl:value-of select="FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:attribute name="firstName">
								<xsl:if test="normalize-space(FirstName/.) != ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
							
							<xsl:if test="normalize-space(LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="concat(LastName/., ', ', FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</title:Actor>
					</xsl:if>
				</xsl:for-each>
				
				<xsl:if test="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'WRITER']">
					<title:WriterDisplay>
						<xsl:for-each select="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'WRITER' and normalize-space(../LastName/.) = '' and normalize-space(../FirstName/.) = ''] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:WriterDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/Sources/Source/Contact[../Role/Name = 'WRITER'] ">
					<xsl:if test="normalize-space(FirstName/.) != '' or normalize-space(LastName/.) != ''">
						<title:Writer>
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(DisplayName/.) != ''">
										<xsl:value-of select="DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="concat(FirstName/., ' ', LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
											<xsl:value-of select="FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:attribute name="firstName">
								<xsl:if test="normalize-space(FirstName/.) != ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
							
							<xsl:if test="normalize-space(LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="concat(LastName/., ', ', FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</title:Writer>
					</xsl:if>
				</xsl:for-each>

				<xsl:if test="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'DIRECTOR']">
					<title:DirectorDisplay>
						<xsl:for-each select="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'DIRECTOR' and normalize-space(../LastName/.) = '' and normalize-space(../FirstName/.) = ''] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:DirectorDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/Sources/Source/Contact[../Role/Name = 'DIRECTOR'] ">
					<xsl:if test="normalize-space(FirstName/.) != '' or normalize-space(LastName/.) != ''">
						<title:Director>
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(DisplayName/.) != ''">
										<xsl:value-of select="DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="concat(FirstName/., ' ', LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
											<xsl:value-of select="FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:attribute name="firstName">
								<xsl:if test="normalize-space(FirstName/.) != ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
							
							<xsl:if test="normalize-space(LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="concat(LastName/., ', ', FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</title:Director>
					</xsl:if>
				</xsl:for-each>

				<xsl:if test="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'PRODUCER']">
					<title:ProducerDisplay>
						<xsl:for-each select="Fields/Sources/Source/Contact/DisplayName[../../Role/Name = 'PRODUCER' and normalize-space(../LastName/.) = '' and normalize-space(../FirstName/.) = ''] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:ProducerDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/Sources/Source/Contact[../Role/Name = 'PRODUCER'] ">
					<xsl:if test="normalize-space(FirstName/.) != '' or normalize-space(LastName/.) != ''">
						<title:Producer>
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(DisplayName/.) != ''">
										<xsl:value-of select="DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="concat(FirstName/., ' ', LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
											<xsl:value-of select="FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
											<xsl:value-of select="LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:attribute name="firstName">
								<xsl:if test="normalize-space(FirstName/.) != ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
							
							<xsl:if test="normalize-space(LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="concat(LastName/., ', ', FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) != '' and normalize-space(LastName/.) = ''">
									<xsl:value-of select="FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(FirstName/.) = '' and normalize-space(LastName/.) != ''">
									<xsl:value-of select="LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</title:Producer>
					</xsl:if>
				</xsl:for-each>

				<xsl:if test="Fields/CreationInfo/Studio/DisplayName">
					<title:StudioDisplay>
						<xsl:value-of select="Fields/CreationInfo/Studio/DisplayName"/>
					</title:StudioDisplay>
				</xsl:if>
				<xsl:for-each select="Fields/TitleArtist">
					<title:RecordingArtist>
						<xsl:value-of select="."/>
					</title:RecordingArtist>
				</xsl:for-each>
				<xsl:for-each select="Fields/TitleArtist">
					<title:RecordingArtistDisplay>
						<xsl:value-of select="."/>
					</title:RecordingArtistDisplay>
				</xsl:for-each>
				<xsl:for-each select="Fields/SongTitle">
					<title:SongTitle>
						<xsl:value-of select="."/>
					</title:SongTitle>
				</xsl:for-each>

				<xsl:if test="Fields/Episode/Name/Value">
					<title:EpisodeName deprecated="true">
						<xsl:value-of select="Fields/Episode/Name/Value"/>
					</title:EpisodeName>
				</xsl:if>
				<xsl:if test="Fields/Episode/Number">
					<title:EpisodeID deprecated="true">
						<xsl:value-of select="Fields/Episode/Number"/>
					</title:EpisodeID>
				</xsl:if>
				<xsl:for-each select="Fields/Chapters/Chapter">
					<title:Chapter>
						<xsl:attribute name="heading">
							<xsl:value-of select="substring-after(., ',')"/>
						</xsl:attribute>	
						<xsl:attribute name="timeCode">
							<xsl:value-of select="substring-before(., ',')"/>
						</xsl:attribute>
					</title:Chapter>
				</xsl:for-each>
			</title:LocalizableTitle>
			</xsl:for-each>
			
			<xsl:for-each select="Fields/Rating/RatingValues/RatingValue">
				<title:Rating>
					<xsl:choose> 
						<xsl:when test="System">
							<xsl:attribute name="ratingSystem"><xsl:value-of select="System" /></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="exists(index-of(('G','PG','PG-13','R','NC-17'),.))"><xsl:attribute name="ratingSystem">MPAA</xsl:attribute></xsl:when>
								<xsl:when test="starts-with(.,'TV')"><xsl:attribute name="ratingSystem">TV</xsl:attribute></xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="Value"/>
				</title:Rating>
			</xsl:for-each>
			<xsl:for-each select="Fields/Rating/MSORatings/MSORating">
				<title:Rating ratingSystem="MSO">
					<xsl:value-of select="."/>
				</title:Rating>
			</xsl:for-each>
			<xsl:for-each select="Fields/Rating/TargetAudiences/TargetAudience">
				<title:Audience>
					<xsl:value-of select="."/>
				</title:Audience>
			</xsl:for-each>
			<xsl:for-each select="Fields/Rating/ContentAdvisories/ContentAdvisory">
				<title:Advisory>
					<xsl:value-of select="."/>
				</title:Advisory>
			</xsl:for-each>
			<xsl:if test="Fields/Caption/Value">
				<title:IsClosedCaptioning><xsl:value-of select="Fields/Caption/Value"/></title:IsClosedCaptioning>
			</xsl:if>
			<xsl:if test="Fields/Duration/Duration">
				<title:DisplayRunTime>
					<xsl:value-of select="Fields/Duration/Duration"/>
				</title:DisplayRunTime>
			</xsl:if>
			<xsl:if test="Fields/CreationInfo/PublicationDate">
				<title:Year><xsl:value-of select="Fields/CreationInfo/PublicationDate"/></title:Year>
			</xsl:if>
			<xsl:if test="Fields/CreationInfo/Place/Country">
				<title:CountryOfOrigin>
					<xsl:choose>
						<xsl:when test="Fields/CreationInfo/Place/Country = 'United States'">US</xsl:when>
						<xsl:otherwise><xsl:value-of select="Fields/CreationInfo/Place/Country"/></xsl:otherwise>
					</xsl:choose>
				</title:CountryOfOrigin>
			</xsl:if>
			<xsl:for-each select="Fields/Genres/Genre">
				<title:Genre>
					<xsl:value-of select="Value"/>
				</title:Genre>
			</xsl:for-each>
			<xsl:if test="count(Fields/Genres/Genre/Value)=0">
				<title:Genre>private:UNKNOWN</title:Genre>
			</xsl:if>
			<title:ShowType>
				<xsl:choose>
					<xsl:when test="Fields/ShowType"><xsl:value-of select="Fields/ShowType"/></xsl:when>
					<xsl:otherwise>private:UNKNOWN</xsl:otherwise>
				</xsl:choose>
			</title:ShowType>
			<xsl:if test="Fields/Episode/SeasonPremier">
				<title:IsSeasonPremier deprecated="true"><xsl:value-of select="Fields/Episode/SeasonPremier"/></title:IsSeasonPremier>
			</xsl:if>

			<xsl:if test="Fields/Episode/SeasonFinale">
				<title:IsSeasonFinale deprecated="true"><xsl:value-of select="Fields/Episode/SeasonFinale"/></title:IsSeasonFinale>
			</xsl:if>
			<xsl:if test="Fields/EncryptionRequired">
				<title:IsEncryptionRequired><xsl:value-of select="Fields/EncryptionRequired"/></title:IsEncryptionRequired>
			</xsl:if>	
			<xsl:if test="Fields/BoxOffice/Value">
				<title:BoxOffice><xsl:value-of select="Fields/BoxOffice/Value"/></title:BoxOffice>
			</xsl:if>

			<xsl:if test="Fields/TvId/CallSign">
				<title:ProgrammerCallLetters>
					<xsl:value-of select="Fields/TvId/CallSign"/>
				</title:ProgrammerCallLetters>
			</xsl:if>
			<xsl:if test="Fields/TvId/Showtime/OriginalAirDate">
				<title:LinearBroadcastDate>
					<xsl:value-of select="Fields/TvId/Showtime/OriginalAirDate"/>
				</title:LinearBroadcastDate>
			</xsl:if>

		</Asset>
	</xsl:template>

	<xsl:template name="Advertisement">
		<xsl:apply-templates select="/ECMFSpec/Package/Title/Fields/Advertisements/Advertisement" />
	</xsl:template>
	<xsl:template name="ContentGroup">
		<Asset xsi:type="offer:ContentGroupType">
			<xsl:attribute name="uriId"><xsl:value-of select="$ContentGroupUriId"/></xsl:attribute>
				<xsl:call-template name="AMS_1" />
				<xsl:if test="/ECMFSpec/Package/MovieSegmentGroup or /ECMFSpec/Package/PreviewSegmentGroup or /ECMFSpec/Package/Fields/TitleGroup">
					<core:Ext>
						<ericsson:ContentGroupExt>
							<xsl:if test="$Title/Fields/CustomFields/CustomField[@name='Is_PlayList']/BooleanValue = 'true'">
								<xsl:if test="(($Package/Fields/TitleGroup/ProviderInfo/Identifier/Id != '') and ($Package/Fields/TitleGroup/Identifier/Id != '')) or $Title/Fields/CustomFields/CustomField[@name='Ever_Playlist_Distributed']/BooleanValue = 'true'">
									<ericsson:MovieSegmentGroupRef>
										<xsl:call-template name="encodeUri">
											<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
											<xsl:with-param name="assetType" select="'/Playlist/'" />
											<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
										</xsl:call-template>
									</ericsson:MovieSegmentGroupRef>
								</xsl:if>
							</xsl:if>
							<xsl:for-each select="/ECMFSpec/Package/MovieSegmentGroup">
								<ericsson:MovieSegmentGroupRef>
									<xsl:call-template name="encodeUri">
										<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
										<xsl:with-param name="assetType" select="'/Playlist/'" />
										<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
									</xsl:call-template>
								</ericsson:MovieSegmentGroupRef> 							
							</xsl:for-each>
							<xsl:for-each select="/ECMFSpec/Package/PreviewSegmentGroup">
								<ericsson:PreviewSegmentGroupRef>
									<xsl:call-template name="encodeUri">
										<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
										<xsl:with-param name="assetType" select="'/Playlist/'" />
										<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
									</xsl:call-template>
								</ericsson:PreviewSegmentGroupRef> 							
							</xsl:for-each>
						</ericsson:ContentGroupExt>					
					</core:Ext>
				</xsl:if>
				<offer:TitleRef>
					<xsl:attribute name="uriId"><xsl:value-of select="$TitleUriId"/></xsl:attribute>
				</offer:TitleRef>
				<xsl:for-each select="$Movie">
					<offer:MovieRef>
						<xsl:call-template name="encodeUri">
							<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
							<xsl:with-param name="assetType" select="'/Asset/'" />
							<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
						</xsl:call-template>
					</offer:MovieRef>
				</xsl:for-each>
				<xsl:for-each select="$Encrypted">
					<xsl:variable name="ancestorAssetType">
						<xsl:call-template name="ancestorAssetType" >
							<xsl:with-param name="assetId" select="Fields/Identifier/Id"/>
						</xsl:call-template>
					</xsl:variable>	
					<xsl:choose>
						<xsl:when test="$ancestorAssetType = 'preview'">
							<offer:PreviewRef>
								<xsl:call-template name="encodeUri">
									<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
									<xsl:with-param name="assetType" select="'/Asset/'" />
									<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
								</xsl:call-template>
							</offer:PreviewRef>
						</xsl:when>
						<xsl:otherwise>
							<offer:MovieRef>
								<xsl:call-template name="encodeUri">
									<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
									<xsl:with-param name="assetType" select="'/Asset/'" />
									<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
								</xsl:call-template>
							</offer:MovieRef>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				<xsl:for-each select="$Preview">
					<offer:PreviewRef>
						<xsl:call-template name="encodeUri">
							<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
							<xsl:with-param name="assetType" select="'/Asset/'" />
							<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
						</xsl:call-template>
					</offer:PreviewRef>
				</xsl:for-each>
				<xsl:for-each select="$Poster">
					<offer:PosterRef>
						<xsl:call-template name="encodeUri">
							<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
							<xsl:with-param name="assetType" select="'/Asset/'" />
							<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
						</xsl:call-template>
					</offer:PosterRef>
				</xsl:for-each>
				<xsl:for-each select="$Boxcover">
					<offer:BoxCoverRef>
						<xsl:call-template name="encodeUri">
							<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
							<xsl:with-param name="assetType" select="'/Asset/'" />
							<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
						</xsl:call-template>
					</offer:BoxCoverRef>
				</xsl:for-each>
				<xsl:for-each select="$Barker">
					<offer:BarkerRef>
						<xsl:call-template name="encodeUri">
							<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
							<xsl:with-param name="assetType" select="'/Asset/'" />
							<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
						</xsl:call-template>
					</offer:BarkerRef>
				</xsl:for-each>
				<xsl:for-each select="$Trick">
					<offer:TrickRef>
						<xsl:call-template name="encodeUri">
							<xsl:with-param name="providerId" select="Fields/ProviderInfo/Identifier/Id" />
							<xsl:with-param name="assetType" select="'/Asset/'" />
							<xsl:with-param name="fieldId" select="Fields/Identifier/Id" />
						</xsl:call-template>
					</offer:TrickRef>
				</xsl:for-each>
		</Asset>
	</xsl:template>

	<xsl:template name="Terms">
		<Asset xsi:type="terms:TermsType">
			<xsl:attribute name="uriId"><xsl:value-of select="$TermsUriId"/></xsl:attribute>
			<xsl:call-template name="AMS_1" />
			
			<xsl:if test="Fields/TermsExt/AuthorizedEquipmentBusinessClasses/AuthorizedEquipmentBusinessClass or Fields/TermsExt/AuthorizedEquipmentCapabilityProfiles/AuthorizedEquipmentCapabilityProfile or Fields/TermsExt/AuthorizedDeliveryMethods/AuthorizedDeliveryMethod or Fields/TermsExt/AuthorizedDeliveryNetworks/AuthorizedDeliveryNetwork or Fields/TermsExt/Geolockings/Geolocking or Fields/TermsExt/Geoblockings/Geoblocking or $Title/Fields/OSVOD/MaxConcurrentViewsAllowed or Fields/TermsExt/Markets">
				<core:Ext>
					<ericsson:TermsExt>
						<xsl:if test="Fields/TermsExt/AuthorizedEquipmentBusinessClasses/AuthorizedEquipmentBusinessClass">
							<xsl:for-each select="Fields/TermsExt/AuthorizedEquipmentBusinessClasses/AuthorizedEquipmentBusinessClass">
								<ericsson:AuthorizedEquipmentBusinessClass>
									<xsl:value-of select="."/>
								</ericsson:AuthorizedEquipmentBusinessClass>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="Fields/TermsExt/AuthorizedEquipmentCapabilityProfiles/AuthorizedEquipmentCapabilityProfile">
							<xsl:for-each select="Fields/TermsExt/AuthorizedEquipmentCapabilityProfiles/AuthorizedEquipmentCapabilityProfile">
								<ericsson:AuthorizedEquipmentCapabilityProfile>
									<xsl:value-of select="."/>
								</ericsson:AuthorizedEquipmentCapabilityProfile>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="Fields/TermsExt/AuthorizedDeliveryMethods/AuthorizedDeliveryMethod">
							<xsl:for-each select="Fields/TermsExt/AuthorizedDeliveryMethods/AuthorizedDeliveryMethod">
								<ericsson:AuthorizedDeliveryMethod>
									<xsl:value-of select="."/>
								</ericsson:AuthorizedDeliveryMethod>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="Fields/TermsExt/AuthorizedDeliveryNetworks/AuthorizedDeliveryNetwork">
							<xsl:for-each select="Fields/TermsExt/AuthorizedDeliveryNetworks/AuthorizedDeliveryNetwork">
								<ericsson:AuthorizedDeliveryNetwork>
									<xsl:value-of select="."/>
								</ericsson:AuthorizedDeliveryNetwork>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="Fields/TermsExt/Geolockings/Geolocking">
							<xsl:for-each select="Fields/TermsExt/Geolockings/Geolocking">
								<ericsson:Geolocking>
									<xsl:value-of select="."/>
								</ericsson:Geolocking>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="Fields/TermsExt/Geoblockings/Geoblocking">
							<xsl:for-each select="Fields/TermsExt/Geoblockings/Geoblocking">
								<ericsson:Geoblocking>
									<xsl:value-of select="."/>
								</ericsson:Geoblocking>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="$Title/Fields/OSVOD/MaxConcurrentViewsAllowed">
						    <ericsson:UsageControlInfo>
						        <xsl:if test="$Title/Fields/OSVOD/MaxConcurrentViewsAllowed">
							        <ericsson:MaximumConcurrentViewsAllowed>
								        <xsl:value-of select="$Title/Fields/OSVOD/MaxConcurrentViewsAllowed"/>
							        </ericsson:MaximumConcurrentViewsAllowed>
						        </xsl:if>
						    </ericsson:UsageControlInfo>
						</xsl:if>
						<xsl:if test="Fields/TermsExt/Markets">
							<xsl:for-each select="Fields/TermsExt/Markets/Market">
								<ericsson:Market>
									<xsl:attribute name="name"><xsl:value-of select="Name"/></xsl:attribute>
									<xsl:attribute name="price"><xsl:value-of select="Price"/></xsl:attribute>
									<xsl:if test="SubMarketName">
										<xsl:attribute name="submarketName"><xsl:value-of select="SubMarketName"/></xsl:attribute>
									</xsl:if>
								</ericsson:Market>
							</xsl:for-each>
						</xsl:if>
					</ericsson:TermsExt>
				</core:Ext>
			</xsl:if>
			
			<xsl:if test="Fields/Rights/Contract/Name">
				<terms:ContractName>
					<xsl:value-of select="Fields/Rights/Contract/Name"/>
				</terms:ContractName>
			</xsl:if>
			<xsl:if test="Fields/Rights/PreviewPeriod/Duration">
				<terms:BillingGracePeriod>PT<xsl:call-template name="durationInSecs"><xsl:with-param name="duration" select="Fields/Rights/PreviewPeriod/Duration" /></xsl:call-template>S</terms:BillingGracePeriod>
			</xsl:if>
			<xsl:if test="Fields/Rights/MaxViewingLimit">
				<terms:UsagePeriod>
					<xsl:variable name="MaxViewingLength" select="Fields/Rights/MaxViewingLimit"/>
					<xsl:variable name="days" select="xs:integer($MaxViewingLength div 1440)"/>
					<xsl:variable name="hours" select="xs:integer(($MaxViewingLength - ($days * 1440)) div 60)"/>
					<xsl:variable name="minutes" select="$MaxViewingLength mod 60"/>
			    	<xsl:choose>
				    	<xsl:when test="$days = 1 and $hours = 0 and $minutes = 0">P00DT24H00M</xsl:when>
				    	<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$days &lt; 10">
									<xsl:choose>
										<xsl:when test="$hours &lt; 10">
											<xsl:choose>
												<xsl:when test="$minutes &lt; 10">
													<xsl:value-of select="concat('P0',$days,'DT0',$hours,'H0',$minutes,'M')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat('P0',$days,'DT0',$hours,'H',$minutes,'M')"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$minutes &lt; 10">
													<xsl:value-of select="concat('P0',$days,'DT',$hours,'H0',$minutes,'M')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat('P0',$days,'DT',$hours,'H',$minutes,'M')"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="$hours &lt; 10">
											<xsl:choose>
												<xsl:when test="$minutes &lt; 10">
													<xsl:value-of select="concat('P',$days,'DT0',$hours,'H0',$minutes,'M')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat('P',$days,'DT0',$hours,'H',$minutes,'M')"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$minutes &lt; 10">
													<xsl:value-of select="concat('P',$days,'DT',$hours,'H0',$minutes,'M')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat('P',$days,'DT',$hours,'H',$minutes,'M')"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</terms:UsagePeriod>
			</xsl:if>
			
			<xsl:if test="Fields/Rights/HomeVideoWindow">
				<terms:HomeVideoWindow>
					<xsl:value-of select="concat('P',Fields/Rights/HomeVideoWindow,'D') "/>
				</terms:HomeVideoWindow>
			</xsl:if>
			
			<xsl:for-each select="Fields/Rights/ViewLimits/ViewLimit">
				<xsl:variable name="subscriberViewLimit" select="tokenize(., ',')"/>
				<terms:SubscriberViewLimit>
					<xsl:attribute name="startDateTime">
						<xsl:call-template name="startDateTime">
							<xsl:with-param name="dateString" select="$subscriberViewLimit[1]" />
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="endDateTime">
						<xsl:call-template name="endDateTime">
							<xsl:with-param name="dateString" select="$subscriberViewLimit[2]" />
						</xsl:call-template>
					</xsl:attribute>				
					<xsl:attribute name="maximumViews"><xsl:value-of select="$subscriberViewLimit[3]"/></xsl:attribute>	
				</terms:SubscriberViewLimit>
			</xsl:for-each>

			<terms:SuggestedPrice>
				<xsl:if test="Fields/BillingInfo/SuggestedPrice/RetailPrice">
					<xsl:attribute name="retail"><xsl:value-of select="Fields/BillingInfo/SuggestedPrice/RetailPrice"/></xsl:attribute>
				</xsl:if>	
				<xsl:if test="Fields/BillingInfo/SuggestedPrice/Currency">
					<xsl:attribute name="currency"><xsl:value-of select="Fields/BillingInfo/SuggestedPrice/Currency"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Fields/BillingInfo/SuggestedPrice/Value">
						<xsl:value-of select="Fields/BillingInfo/SuggestedPrice/Value"/>
					</xsl:when>
					<xsl:otherwise>0.00</xsl:otherwise>
				</xsl:choose>
			</terms:SuggestedPrice>

			<xsl:if test="Fields/Distributor/Name or Fields/Distributor/RoyaltyInfo/RoyaltyPercent or Fields/Distributor/RoyaltyInfo/RoyaltyMinimum or Fields/Distributor/RoyaltyInfo/RoyaltyFlatRate">
				<terms:DistributorRoyaltyInfo>
					<xsl:if test="Fields/Distributor/Name">
						<terms:OrganizationName>
							<xsl:value-of select="Fields/Distributor/Name"/>
						</terms:OrganizationName>
					</xsl:if>
					<xsl:if test="Fields/Distributor/RoyaltyInfo/RoyaltyPercent">
						<terms:RoyaltyPercent>
							<xsl:value-of select="Fields/Distributor/RoyaltyInfo/RoyaltyPercent"/>
						</terms:RoyaltyPercent>
					</xsl:if>
					<xsl:if test="Fields/Distributor/RoyaltyInfo/RoyaltyMinimum">
						<terms:RoyaltyMinimum>
							<xsl:value-of select="Fields/Distributor/RoyaltyInfo/RoyaltyMinimum"/>
						</terms:RoyaltyMinimum>
					</xsl:if>
					<xsl:if test="Fields/Distributor/RoyaltyInfo/RoyaltyFlatRate">
						<terms:RoyaltyFlatRate>
							<xsl:value-of select="Fields/Distributor/RoyaltyInfo/RoyaltyFlatRate"/>
						</terms:RoyaltyFlatRate>
					</xsl:if>
				</terms:DistributorRoyaltyInfo>
			</xsl:if>
			<xsl:if test="Fields/CreationInfo/Studio/Name or Fields/CreationInfo/Studio/Code or Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyPercent or Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyMinimum or Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyFlatRate">
				<terms:StudioRoyaltyInfo>
					<xsl:if test="Fields/CreationInfo/Studio/Name">
						<terms:OrganizationName>
							<xsl:value-of select="Fields/CreationInfo/Studio/Name"/>
						</terms:OrganizationName>
					</xsl:if>
					<xsl:if test="Fields/CreationInfo/Studio/Code">
						<terms:OrganizationCode>
							<xsl:value-of select="Fields/CreationInfo/Studio/Code"/>
						</terms:OrganizationCode>
					</xsl:if>
					<xsl:if test="Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyPercent">
						<terms:RoyaltyPercent>
							<xsl:value-of select="Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyPercent"/>
						</terms:RoyaltyPercent>
					</xsl:if>
					<xsl:if test="Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyMinimum">
						<terms:RoyaltyMinimum>
							<xsl:value-of select="Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyMinimum"/>
						</terms:RoyaltyMinimum>
					</xsl:if>
					<xsl:if test="Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyFlatRate">
						<terms:RoyaltyFlatRate>
							<xsl:value-of select="Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyFlatRate"/>
						</terms:RoyaltyFlatRate>
					</xsl:if>
				</terms:StudioRoyaltyInfo>				
			</xsl:if>
			
			<xsl:if test="Fields/Rights/ViewingCanBeResumed">
				<terms:IsResumeEnabled>
					<xsl:value-of select="Fields/Rights/ViewingCanBeResumed"/>
				</terms:IsResumeEnabled>
			</xsl:if>
			
			<xsl:if test="Fields/TrickModeRestrictions/TrickModeRestriction">
				<terms:TrickModesRestricted>
					<xsl:if test="contains(Fields/TrickModeRestrictions/TrickModeRestriction, 'FF')">
						<core:TrickModeExclusion type="trick" scale="0.0,100"></core:TrickModeExclusion>
					</xsl:if>
					<xsl:if test="contains(Fields/TrickModeRestrictions/TrickModeRestriction, 'RW')">
						<core:TrickModeExclusion type="trick" scale="-100,0.0"></core:TrickModeExclusion>
					</xsl:if>
					<xsl:if test="contains(Fields/TrickModeRestrictions/TrickModeRestriction, 'RW')">
						<core:TrickModeExclusion type="pause"></core:TrickModeExclusion>
					</xsl:if>
				</terms:TrickModesRestricted>
			</xsl:if>
			
			<xsl:if test="Fields/TermsType">
				<terms:TermsType>
					<xsl:value-of select="Fields/TermsType"/>
				</terms:TermsType>
			</xsl:if>
			<xsl:if test="Fields/TermsDescription/Text">
				<terms:Description>
					<xsl:if test="Fields/TermsDescription/Language">
						<xsl:attribute name="xml:lang"><xsl:value-of select="Fields/TermsDescription/Language/@value"/></xsl:attribute>
					</xsl:if>
					<xsl:value-of select="Fields/TermsDescription/Text"/>
				</terms:Description>
			</xsl:if>
		</Asset>
	</xsl:template>
 
	<xsl:template name="Category">
		<!-- <xsl:for-each select="$Title">
			<xsl:for-each select="Fields/Categories/Category">
				<Asset xsi:type="offer:CategoryType">
					<xsl:call-template name="AMS_1" />
					<xsl:if test="Text">
						<xsl:call-template name="encodeCategoryUri" />
						<offer:CategoryPath>
							<xsl:value-of select="Text"/>
						</offer:CategoryPath>
					</xsl:if>
					<xsl:if test="Market">
						<core:Ext>
							<ericsson:CategoryExt>
								<ericsson:Market>
									<xsl:value-of select="Market"/>
								</ericsson:Market>
							</ericsson:CategoryExt>
						</core:Ext>
					</xsl:if>
				</Asset>
			</xsl:for-each>
		</xsl:for-each> -->
		
		<!-- translate from Temporiry Category group of package
		   /Fields[1]/CategoriesTmp[1]/Category[pos1]/Text[pos2]
		   /Fields[1]/CategoriesTmp[1]/Category[pos1]/Market[pos2] -->
		<xsl:for-each select="$Package">
			<xsl:for-each select="Fields/CategoriesTmp/Category">
				<Asset xsi:type="offer:CategoryType">
					<xsl:call-template name="AMS_3" />
					<xsl:if test="Text">
						<xsl:call-template name="encodeCategoryUri" />
					</xsl:if>
					<xsl:if test="Market">
						<core:Ext>
							<ericsson:CategoryExt>
								<xsl:for-each select="Market">
									<ericsson:Market>
										<xsl:value-of select="."/>
									</ericsson:Market>
								</xsl:for-each>
							</ericsson:CategoryExt>
						</core:Ext>
					</xsl:if>
					<xsl:if test="Text">
						<offer:CategoryPath>
							<xsl:value-of select="Text"/>
						</offer:CategoryPath>
					</xsl:if>
				</Asset>
			</xsl:for-each>
		</xsl:for-each>
		
		<xsl:for-each select="$Display">
			<xsl:for-each select="Fields/Categories/Category">
				<Category>
					<xsl:call-template name="AMS_1" />
					<xsl:if test="Text">
						<xsl:call-template name="encodeCategoryUri" />
						<offer:CategoryPath>
							<xsl:value-of select="Text"/>
						</offer:CategoryPath>
					</xsl:if>
				</Category>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>