#!/bin/bash
source ./common/CleanCache.sh

invalidArgs=false
username="empty!"
password="empty!"
option=""
optionArg=""
myArray=( "$@" )
numberOfArgs=${#myArray[@]}

function printErrorInfo(){
	echo -e "\033[37;31;5m#####################################################################################\033[39;49;0m"
	echo -e "\033[37;31;5m#################This shell is used to clean Common Property Cache###################\033[39;49;0m"
	echo -e "\033[37;31;5m#####################################################################################\033[39;49;0m"
	echo "DESCRIPTION"
	echo "	This shell is used to clean Common Property Cache. Options like -a, -l require
	access to DB. So, if DB Username or Password is updated, it is required to
	use the option with -u and -p."
	
	echo "OPTIONS"
	echo "	-k"
	echo "	  Clean one or multiple caches. For example:"      
	echo "	  sh cleanCommonPropertyCache.sh -k cacheKey"      
	echo "	  sh cleanCommonPropertyCache.sh -k \"cacheKey1, cacheKey2,... cacheKey3\""
	echo "	-a"
	echo "	  Clean all the caches. This option requries access to DB."
	echo "	-l"
	echo "	  List entries in caches. This option requries access to DB."
	echo "	-u"
	echo "	  DB username."
	echo "	-p"
	echo "	  DB password."
	exit 1
}


#echo "numberOfArgs$numberOfArgs"
if [[ $numberOfArgs -eq 0 ]]; then
	invalidArgs=true
else
	for(( idx=0; $idx<$numberOfArgs; idx++ ))
	do
		validateOption 
		#echo "username=$username password=$password option=$option optionargs=$optionArg"
		if [[ $invalidArgs == "true" ]]; then
				printErrorInfo
		fi
	done
fi
#echo "username=$username password=$password option=$option optionargs=$optionArg"
if [[ $invalidArgs == "true" ]]; then
        printErrorInfo
fi

readonly cacheType=3
readonly cacheName=CommonProperty
#echo "all params: $@"
echo -e "\033[37;31;5m#####################################################################################\033[39;49;0m"
echo -e "\033[37;31;5m#################This shell is used to clean Common Property Cache###################\033[39;49;0m"
echo -e "\033[37;31;5m#####################################################################################\033[39;49;0m"

case "$option" in
	-k)
		 cacheCleanMain $cacheType $cacheName "no" $(echo $optionArg | sed 's/ //g') $username $password;;
	-a)
		 cacheCleanMain $cacheType $cacheName "yes" "" $username $password;;
	-l)	 
		 listAllCache $cacheType $cacheName $username $password;;
esac	
