#!/bin/bash

db_user='wfs'
db_password='Wf$1234'
readonly db_host='dbserver'
readonly host='localhost'
readonly db_sid="ttv"
readonly db_port='5444'
readonly empty_param='empty!'
declare PSQLCMD
declare ALLCACHES
set -e

validateOption(){
	#echo "validation started=${myArray[idx]} idx=$idx"
	if [[ ${myArray[idx]} != "-a" && ${myArray[idx]} != "-k" && ${myArray[idx]} != "-l" && ${myArray[idx]} != "-u" && ${myArray[idx]} != "-p" ]];then
		invalidArgs=true			
	else
		case "${myArray[idx]}" in
				-l)
					 option=${myArray[idx]}
					 optionArg="";;
				-k)
					 if [[ $option != "-l" && $idx < $(expr $numberOfArgs - 1) ]]; then
						option=${myArray[idx]}	
						idx=$(expr $idx + 1)
						optionArg=${myArray[idx]}
					 elif [[ $option == "-l" ]];then
						idx=$(expr $idx + 1)
					 elif [[ $option != "-l" ]];then
						invalidArgs=true			
					 fi;;
				-a)
					 if [[ $option != "-k" && $option != "-l" ]]; then
						option=${myArray[idx]}
						optionArg=""
					 fi;;
				-u)
					 if [[ $idx < $(expr $numberOfArgs - 1) ]]; then
						idx=$(expr $idx + 1)
						username=${myArray[idx]}
					 else	
					    	invalidArgs=true						
					 fi;;
				-p)	
					 if [[ $idx < $(expr $numberOfArgs - 1) ]]; then
						idx=$(expr $idx + 1)
						password=${myArray[idx]}
					 else	
					   	 invalidArgs=true			
					 fi;;
		esac	
	fi
        #echo "username=$username password=$password option=$option optionargs=$optionArg"
}


getPgsqlCMD(){      
	CMSVersion=$(cat /opt/tandbergtv/cms/product.properties | grep product.version | awk -F '=' '{print $2}' | cut -c -1 | bc)
        #echo "Running script on ${CMSVersion}.x cms"
        if [[ $CMSVersion -ge 6 ]];
        then
            PSQLCMD='/usr/pgsql-9.5/bin/psql'
        else
            PSQLCMD='/opt/PostgresPlus/9.3AS/bin/psql'
        fi
}

clearCache(){
	IFS=' '
	CACHES=($1)
	cName=$2
	numberOfCaches=${#CACHES[@]}
	for((i=0;i<$numberOfCaches;i++))
	do
	   cachename=${CACHES[$i]}
	   echo "Trying to clean cache '${cachename}'..."
	   curl -XDELETE  http://$host:5722/hazelcast/rest/maps/$cName/${cachename}
	done
	echo "Caches have been deleted successfully!"
}


getAllCache(){
	getPgsqlCMD
	cType=$1
	ALLCACHES=($(PGPASSWORD="$db_password" $PSQLCMD -p $db_port -h $db_host -U $db_user -d $db_sid -c "select key from distributed_cacheinfo where type=$cacheType" | head -n -2 | tail -n+3))
}

listAllCache(){
	cType=$1
        dbUsername=$3
        dbPassword=$4
        if [[ ($dbUsername != $empty_param) ]];then
                db_user=$dbUsername
        fi
        if [[ ($dbPassword != $empty_param) ]];then
                db_password=$dbPassword
        fi
        #echo "dbUsername=$db_user,dbPassword=$db_password"
	getAllCache  $cType
        cName=$2
        numberOfCaches=${#ALLCACHES[@]}
	if [[ ${ALLCACHES[@]} == "" ]];
	then
		echo "No entry found in Cache."
        else
		echo "Found below entries in Cache: "
		for((i=0;i<$numberOfCaches;i++))
	        do
	        	cachename=${ALLCACHES[$i]}
		        echo "'${cachename}'"
        	done
	fi
}

function cacheCleanMain(){	
	cType=$1
	clearAll=$3
	cName=$2
	dbUsername=$5
	dbPassword=$6
 	cacheToBeCleaned=""
	if [[ ($dbUsername != $empty_param) ]];then 
		db_user=$dbUsername
	fi
	if [[ ($dbPassword != $empty_param) ]];then
		db_password=$dbPassword
	fi
        #echo "dbUsername=$db_user,dbPassword=$db_password"
	if [[ "$clearAll" == "yes" ]];
	then 
		getAllCache $cType
		cacheToBeCleaned=${ALLCACHES[@]}
	        echo "Found ${#ALLCACHES[@]} entry(s) in total"
	else
		IFS=',' 
		cacheToBeCleaned=($4)
	fi

	if [[ ${cacheToBeCleaned[@]} == "" ]];
	then 
		echo 'no cache to clean. exiting...'
		exit 1
	else
		clearCache "$(echo ${cacheToBeCleaned[@]})" $cName
	fi
}

