#!/bin/bash
#Usage: removeConsulService.sh <hostname/ip> <serviceId>
set -e
SCRIPTNAME=$(basename $0 .sh)

if (( $# !=2 ));then
   printf  "Illegal number of parameters. Please supply only two parameters!\n-Usage: removeConsulService.sh <hostname/ip> <serviceId> \n "
   exit 1
fi

Consul_Hostname=$1
serviceId=$2

clientAddress="http://${Consul_Hostname}:8500"
HTTP_ENDPOINT_SRV_UNREG="${clientAddress}/v1/agent/service/deregister"

curl -X PUT "${HTTP_ENDPOINT_SRV_UNREG}/${serviceId}"
echo 'Remove consul service:'${serviceId} 'on' ${Consul_Hostname} 'successfully!'

