﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:signaling="urn:cablelabs:md:xsd:signaling:3.0"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">
	
	
	<xsl:template match="/ADI3/Asset[@xsi:type='terms:TermsType']">
		<xsl:if test="$Offer/offer:BillingId or terms:SuggestedPrice">
			<BillingInfo>
				<xsl:if test="$Offer/offer:BillingId">
					<Identifier>
						<Id><xsl:value-of select="$Offer/offer:BillingId"/></Id>
					</Identifier>
				</xsl:if>
				
				<xsl:if test="terms:SuggestedPrice">
					<SuggestedPrice>
						<Value>
							<xsl:value-of select="terms:SuggestedPrice"/>
						</Value>
						<xsl:if test="terms:SuggestedPrice/@currency">
							<Currency><xsl:value-of select="terms:SuggestedPrice/@currency"/></Currency>
						</xsl:if>
						<xsl:if test="terms:SuggestedPrice/@retail">
							<RetailPrice><xsl:value-of select="terms:SuggestedPrice/@retail"/></RetailPrice>
						</xsl:if>
					</SuggestedPrice>
					</xsl:if>
			</BillingInfo>
		</xsl:if>
		
		<xsl:if test="$Title/@creationDateTime or $Title/title:CountryOfOrigin or $Title/title:Year or $Title/title:LocalizableTitle/title:StudioDisplay or terms:StudioRoyaltyInfo">
			<CreationInfo>
				<xsl:if test="$Title/@creationDateTime">
					<CreateDate><xsl:value-of select="$Title/@creationDateTime"/></CreateDate>
				</xsl:if>
				
				<xsl:if test="$Title/title:CountryOfOrigin">
					<Place>
						<Country><xsl:value-of select="$Title/title:CountryOfOrigin"/></Country>
					</Place>
				</xsl:if>
				
				<xsl:if test="$Title/title:Year">
					<PublicationDate><xsl:value-of select="$Title/title:Year"/></PublicationDate>
				</xsl:if>
				
				<xsl:if test="$Title/title:LocalizableTitle/title:StudioDisplay or terms:StudioRoyaltyInfo">
					<Studio>
						<xsl:if test="$Title/title:LocalizableTitle/title:StudioDisplay">
							<DisplayName><xsl:value-of select="$Title/title:LocalizableTitle/title:StudioDisplay"/></DisplayName>
						</xsl:if>
						
						<xsl:if test="terms:StudioRoyaltyInfo/terms:OrganizationCode">
							<Code><xsl:value-of select="terms:StudioRoyaltyInfo/terms:OrganizationCode"/></Code>
						</xsl:if>
						<xsl:if test="terms:StudioRoyaltyInfo/terms:OrganizationName">
							<Name><xsl:value-of select="terms:StudioRoyaltyInfo/terms:OrganizationName"/></Name>
						</xsl:if>
						
						<xsl:if test="terms:StudioRoyaltyInfo/terms:RoyaltyFlatRate or terms:StudioRoyaltyInfo/terms:RoyaltyMinimum or terms:StudioRoyaltyInfo/terms:RoyaltyPercent">
							<RoyaltyInfo>
								<xsl:if test="terms:StudioRoyaltyInfo/terms:RoyaltyFlatRate">
									<RoyaltyFlatRate><xsl:value-of select="terms:StudioRoyaltyInfo/terms:RoyaltyFlatRate"/></RoyaltyFlatRate>
								</xsl:if>
								<xsl:if test="terms:StudioRoyaltyInfo/terms:RoyaltyMinimum">
									<RoyaltyMinimum><xsl:value-of select="terms:StudioRoyaltyInfo/terms:RoyaltyMinimum"/></RoyaltyMinimum>
								</xsl:if>
								<xsl:if test="terms:StudioRoyaltyInfo/terms:RoyaltyPercent">
									<RoyaltyPercent><xsl:value-of select="terms:StudioRoyaltyInfo/terms:RoyaltyPercent"/></RoyaltyPercent>
								</xsl:if>
							</RoyaltyInfo>
						</xsl:if>
					</Studio>
				</xsl:if>
			</CreationInfo>
		</xsl:if>
		
		<xsl:if test="terms:DistributorRoyaltyInfo">
			<Distributor>
				<xsl:if test="terms:DistributorRoyaltyInfo/terms:OrganizationName">
					<Name><xsl:value-of select="terms:DistributorRoyaltyInfo/terms:OrganizationName"/></Name>
				</xsl:if>
				
				<xsl:if test="terms:DistributorRoyaltyInfo/terms:RoyaltyFlatRate or terms:DistributorRoyaltyInfo/terms:RoyaltyMinimum or terms:DistributorRoyaltyInfo/terms:RoyaltyPercent">
					<RoyaltyInfo>
						<xsl:if test="terms:DistributorRoyaltyInfo/terms:RoyaltyFlatRate">
							<RoyaltyFlatRate><xsl:value-of select="terms:DistributorRoyaltyInfo/terms:RoyaltyFlatRate"/></RoyaltyFlatRate>
						</xsl:if>
						<xsl:if test="terms:DistributorRoyaltyInfo/terms:RoyaltyMinimum">
							<RoyaltyMinimum><xsl:value-of select="terms:DistributorRoyaltyInfo/terms:RoyaltyMinimum"/></RoyaltyMinimum>
						</xsl:if>
						<xsl:if test="terms:DistributorRoyaltyInfo/terms:RoyaltyPercent">
							<RoyaltyPercent><xsl:value-of select="terms:DistributorRoyaltyInfo/terms:RoyaltyPercent"/></RoyaltyPercent>
						</xsl:if>
					</RoyaltyInfo>
				</xsl:if>
			</Distributor>
		</xsl:if>
		
		<xsl:if test="$Offer/offer:Presentation/offer:DisplayAsLastChance or $Offer/offer:Presentation/offer:DisplayAsNew 
					or $Offer/@startDateTime or $Offer/@endDateTime
					or terms:ContractName or terms:HomeVideoWindow or terms:HomeVideoWindow or terms:UsagePeriod 
					or terms:BillingGracePeriod or terms:SubscriberViewLimit">
			<Rights>
				<xsl:if test="$Offer/offer:Presentation[1]/offer:DisplayAsLastChance">
					<DisplayAsLastChance><xsl:value-of select="replace($Offer/offer:Presentation[1]/offer:DisplayAsLastChance, 'P|D', '')"/></DisplayAsLastChance>
				</xsl:if>
				<xsl:if test="$Offer/offer:Presentation[1]/offer:DisplayAsNew">
					<NewReleaseWindow><xsl:value-of select="replace($Offer/offer:Presentation[1]/offer:DisplayAsNew, 'P|D', '')"/></NewReleaseWindow>
				</xsl:if>
				
				<xsl:if test="$Offer/@startDateTime">
					<LicensingWindowStart><xsl:value-of select="$Offer/@startDateTime"/></LicensingWindowStart>
				</xsl:if>
				<xsl:if test="$Offer/@endDateTime">
					<LicensingWindowEnd><xsl:value-of select="$Offer/@endDateTime"/></LicensingWindowEnd>
				</xsl:if>
				
				<xsl:if test="terms:ContractName">
					<Contract>
						<Name><xsl:value-of select="terms:ContractName"/></Name>
					</Contract>
				</xsl:if>
				<xsl:if test="terms:HomeVideoWindow">
					<HomeVideoWindow><xsl:value-of select="replace(terms:HomeVideoWindow, 'P|D', '')"/></HomeVideoWindow>
				</xsl:if>
				<xsl:if test="terms:UsagePeriod">
					<xsl:analyze-string select="terms:UsagePeriod" regex="P([0-9]{{2}})DT([0-9]{{2}})H([0-9]{{2}})M">
						<xsl:matching-substring>
							<xsl:variable name="day" select="regex-group(1)"/>
							<xsl:variable name="hour" select="regex-group(2)"/>
							<xsl:variable name="minute" select="regex-group(3)"/>
							<MaxViewingLimit><xsl:value-of select="number($day)*24*60 + number($hour)*60 + number($minute)"/></MaxViewingLimit>
						</xsl:matching-substring>
					</xsl:analyze-string>
				</xsl:if>
				<xsl:if test="terms:BillingGracePeriod">
					<PreviewPeriod>
						<Duration>
							<xsl:analyze-string select="terms:BillingGracePeriod" regex="PT([0-9]+)S">
								<xsl:matching-substring>
									<xsl:variable name="secondPeriod" select="regex-group(1)"/>
									<xsl:variable name="hour" select="xs:integer(number($secondPeriod) div (60*60))"/>
									<xsl:variable name="minute" select="xs:integer((number($secondPeriod) - ($hour * 60 * 60)) div 60)"/>
									<xsl:variable name="second" select="number($secondPeriod) mod 60"/>
									<xsl:number value="$hour" format="01"/>
									<xsl:text>:</xsl:text>
									<xsl:number value="$minute" format="01"/>
									<xsl:text>:</xsl:text>
									<xsl:number value="$second" format="01"/>
								</xsl:matching-substring>
							</xsl:analyze-string>
						</Duration>
					</PreviewPeriod>
				</xsl:if>
				<xsl:if test="terms:SubscriberViewLimit">
					<ViewLimits>
						<xsl:for-each select="terms:SubscriberViewLimit">
							<ViewLimit><xsl:value-of select="concat(substring-before(@startDateTime, 'T'), ',', substring-before(@endDateTime, 'T'), ',', @maximumViews)"/></ViewLimit>
						</xsl:for-each>
					</ViewLimits>
				</xsl:if>
			</Rights>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="/ADI3/Asset[@xsi:type='offer:CategoryType']">
		<xsl:if test="offer:CategoryPath">
			<Category>
				<Text><xsl:value-of select="offer:CategoryPath"/></Text>
			</Category>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="/ADI3/Asset[@xsi:type='title:TitleType']">
		<AssetClass>title</AssetClass>
		
		<xsl:call-template name="AMSMD" />
		
		<xsl:if test="title:BoxOffice">
			<BoxOffice>
				<Value><xsl:value-of select="title:BoxOffice"/></Value>
			</BoxOffice>
		</xsl:if>
		
		<xsl:if test="title:IsClosedCaptioning">
			<Caption>
				<Value><xsl:value-of select="title:IsClosedCaptioning"/></Value>
			</Caption>
		</xsl:if>
		
		<xsl:if test="title:LocalizableTitle/title:Chapter">
			<Chapters>
				<xsl:for-each select="title:LocalizableTitle/title:Chapter">
					<Chapter><xsl:value-of select="concat(@timeCode,',',@heading)"/></Chapter>
				</xsl:for-each>
			</Chapters>
		</xsl:if>
		
		<xsl:if test="title:DisplayRunTime">
			<Duration>
				<DisplayDuration><xsl:value-of select="title:DisplayRunTime"/></DisplayDuration>
			</Duration>
		</xsl:if>
		
		<xsl:if test="title:IsEncryptionRequired">
			<EncryptionRequired><xsl:value-of select="title:IsEncryptionRequired"/></EncryptionRequired>
		</xsl:if>
		
		<xsl:if test="title:LocalizableTitle or title:IsSeasonFinale or title:IsSeasonPremiere">
			<Episode>
				<xsl:if test="title:LocalizableTitle/title:EpisodeName">
					<Name>
						<Value><xsl:value-of select="title:LocalizableTitle/title:EpisodeName"/></Value>
					</Name>
				</xsl:if>
				<xsl:if test="title:LocalizableTitle/title:EpisodeID">
					<Number><xsl:value-of select="title:LocalizableTitle/title:EpisodeID"/></Number>
				</xsl:if>
				<xsl:if test="title:IsSeasonFinale">
					<SeasonFinale><xsl:value-of select="title:IsSeasonFinale"/></SeasonFinale>
				</xsl:if>
				<xsl:if test="title:IsSeasonPremiere">
					<SeasonPremier><xsl:value-of select="title:IsSeasonPremiere"/></SeasonPremier>
				</xsl:if>
			</Episode>
		</xsl:if>
		
		<xsl:if test="title:Genre">
			<Genres>
				<xsl:for-each select="title:Genre">
					<Genre>
						<Value><xsl:value-of select="."/></Value>
					</Genre>
				</xsl:for-each>
			</Genres>
		</xsl:if>
		
		<xsl:if test="core:AlternateId/@identifierSystem = 'ISAN'">
			<ISAN><xsl:value-of select="core:AlternateId[@identifierSystem = 'ISAN']"/></ISAN>
		</xsl:if>
		
		<xsl:if test="$Movie/content:PropagationPriority">
			<PropagationPriority><xsl:value-of select="$Movie[1]/content:PropagationPriority"/></PropagationPriority>
		</xsl:if>
		
		<xsl:if test="core:ProviderQAContact">
			<ProviderQAContact>
				<Value><xsl:value-of select="core:ProviderQAContact"/></Value>
			</ProviderQAContact>
		</xsl:if>
		
		<xsl:if test="title:Advisory or title:Audience or title:Rating">
			<Rating>
				<xsl:if test="title:Advisory">
					<ContentAdvisories>
						<xsl:for-each select="title:Advisory">
							<ContentAdvisory><xsl:value-of select="."/></ContentAdvisory>
						</xsl:for-each>
					</ContentAdvisories>
				</xsl:if>
				
				<xsl:if test="title:Audience">
					<TargetAudiences>
						<xsl:for-each select="title:Audience">
							<TargetAudience><xsl:value-of select="."/></TargetAudience>
						</xsl:for-each>
					</TargetAudiences>
				</xsl:if>
				
				<xsl:if test="title:Rating/@ratingSystem='MSO'">
					<MSORatings>
						<xsl:for-each select="title:Rating[@ratingSystem='MSO']">
							<MSORating><xsl:value-of select="."/></MSORating>
						</xsl:for-each>
					</MSORatings>
				</xsl:if>
				<xsl:if test="title:Rating/@ratingSystem != 'MSO'">
					<RatingValues>
						<xsl:for-each select="title:Rating[@ratingSystem != 'MSO']">
							<RatingValue>
								<System><xsl:value-of select="@ratingSystem"/></System>
								<Value><xsl:value-of select="."/></Value>
							</RatingValue>
						</xsl:for-each>
					</RatingValues>
				</xsl:if>
			</Rating>
		</xsl:if>
		
		<xsl:if test="title:ShowType">
			<ShowType><xsl:value-of select="title:ShowType"/></ShowType>
		</xsl:if>
		<xsl:if test="title:LocalizableTitle/title:SongTitle">
			<SongTitle><xsl:value-of select="title:LocalizableTitle/title:SongTitle"/></SongTitle>
		</xsl:if>
		
		<xsl:if test="title:LocalizableTitle/title:ActorDisplay or title:LocalizableTitle/title:WriterDisplay
				or title:LocalizableTitle/title:Actor or title:LocalizableTitle/title:Director or title:LocalizableTitle/title:Producer ">
			<Sources>
				<xsl:if test="title:LocalizableTitle/title:ActorDisplay">
					<Source>
						<Contact>
							<DisplayName><xsl:value-of select="title:LocalizableTitle/title:ActorDisplay"/></DisplayName>
						</Contact>
						<Role><Name>ACTOR</Name></Role>
					</Source>
				</xsl:if>
				
				<xsl:for-each select="tokenize(title:LocalizableTitle/title:WriterDisplay,',')">
					<Source>
						<Contact>
							<FirstName><xsl:value-of select="tokenize(.,' ')[1]"/></FirstName>
							<LastName><xsl:value-of select="tokenize(.,' ')[last()]"/></LastName>
						</Contact>
						<Role><Name>WRITER</Name></Role>
					</Source>
				</xsl:for-each>
				
				<xsl:for-each select="title:LocalizableTitle/title:Actor">
					<Source>
						<Contact>
							<FirstName><xsl:value-of select="@firstName"/></FirstName>
							<LastName><xsl:value-of select="@lastName"/></LastName>
						</Contact>
						<Role><Name>ACTOR</Name></Role>
					</Source>
				</xsl:for-each>
				<xsl:for-each select="title:LocalizableTitle/title:Director">
					<Source>
						<Contact>
							<FirstName><xsl:value-of select="@firstName"/></FirstName>
							<LastName><xsl:value-of select="@lastName"/></LastName>
						</Contact>
						<Role><Name>DIRECTOR</Name></Role>
					</Source>
				</xsl:for-each>
				<xsl:for-each select="title:LocalizableTitle/title:Producer">
					<Source>
						<Contact>
							<FirstName><xsl:value-of select="@firstName"/></FirstName>
							<LastName><xsl:value-of select="@lastName"/></LastName>
						</Contact>
						<Role><Name>PRODUCER</Name></Role>
					</Source>
				</xsl:for-each>
			</Sources>
		</xsl:if>
		
		<xsl:if test="title:LocalizableTitle/title:SummaryLong or title:LocalizableTitle/title:SummaryMedium or title:LocalizableTitle/title:SummaryShort">
			<Summary>
				<xsl:if test="title:LocalizableTitle/title:SummaryLong">
					<DisplaySummary>
						<Value><xsl:value-of select="title:LocalizableTitle/title:SummaryLong"/></Value>
					</DisplaySummary>
				</xsl:if>
				<xsl:if test="title:LocalizableTitle/title:SummaryMedium">
					<MediumSummary>
						<Value><xsl:value-of select="title:LocalizableTitle/title:SummaryMedium"/></Value>
					</MediumSummary>
				</xsl:if>
				<xsl:if test="title:LocalizableTitle/title:SummaryShort">
					<ShortSummary>
						<Value><xsl:value-of select="title:LocalizableTitle/title:SummaryShort"/></Value>
					</ShortSummary>
				</xsl:if>
			</Summary>
		</xsl:if>
		
		<xsl:if test="title:LocalizableTitle/title:TitleSortName or title:LocalizableTitle/title:TitleBrief or title:LocalizableTitle/title:TitleLong">
			<Title>
				<xsl:if test="title:LocalizableTitle/title:TitleSortName">
					<SortTitle>
						<Value><xsl:value-of select="title:LocalizableTitle/title:TitleSortName"/></Value>
					</SortTitle>
				</xsl:if>
				<xsl:if test="title:LocalizableTitle/title:TitleBrief">
					<ShortTitle>
						<Value><xsl:value-of select="title:LocalizableTitle/title:TitleBrief"/></Value>
					</ShortTitle>
				</xsl:if>
				<xsl:if test="title:LocalizableTitle/title:TitleLong">
					<DisplayTitle>
						<Value><xsl:value-of select="title:LocalizableTitle/title:TitleLong"/></Value>
					</DisplayTitle>
				</xsl:if>
			</Title>
		</xsl:if>
		
		<xsl:if test="title:LocalizableTitle/title:RecordingArtist">
			<TitleArtist><xsl:value-of select="title:LocalizableTitle/title:RecordingArtist"/></TitleArtist>
		</xsl:if>
		<xsl:if test="title:ProgrammerCallLetters">
			<TvId>
				<CallSign><xsl:value-of select="title:ProgrammerCallLetters"/></CallSign>
			</TvId>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>