#!/usr/bin/env python

import os
import sys
import urlparse
import shutil


class FileCopy:
    
    def __init__(self):
        self.result = None
        self.source = None
        self.destination = None
    
    def getResult(self):
        return self.result
    
    def copyFile(self, source, destination):
        #print "source: " + source + " destination: " + destination 
        if not os.path.exists(source):
            self.result = "Error: File patch: "+ source + " is not found"
            print self.result
            return
        
        if os.path.isdir(source):
            self.result = "Error: File patch: "+ source + " is a directory which cannot be copied. Operation not allowed."
            print self.result
            return        
        
        if os.path.abspath(destination)==os.path.abspath(source):
            self.result = "Error: Cannot copy file when the source and destination paths are the same.";
            print self.result
            return       


        try:
            if os.path.isdir(destination):
                destination = os.path.join(destination, os.path.basename(source))
            elif not os.path.exists(destination) and destination.endswith('/'):
                self.mkdir_p(destination)
                destination = os.path.join(destination, os.path.basename(source))
            elif not os.path.exists(destination) and not os.path.exists(os.path.dirname(destination)):
                self.mkdir_p(os.path.dirname(destination))
                            
            shutil.copyfile(source, destination)
            shutil.copymode(source, destination)
            #os.chmod(destination, 0777)
        except Exception, e:
            excType = e.__class__.__name__
            self.result = excType+ ": "+str(e)
        else:
            self.result = "Successful"
            
        print self.result

    def mkdir_p(self, path):
        """ 'mkdir -p' in Python """
        try:
            os.makedirs(path)
        except OSError as exc:  # Python >2.5
            if exc.errno == errno.EEXIST and os.path.isdir(path):
                pass
            else:
                raise
            
    def validateParameters(self):  
        if self.source is None or self.source == "":
            self.result = "Error: source parameter is mandatory"
            print self.result
            return False
            
        if self.destination is None or self.destination == "":
            self.result = "Error: destination parameter is mandatory"
            print self.result
            return False
        
        return True      

    def parseURL(self,url):

        parsed = urlparse.urlparse(url)
        
        if urlparse.parse_qs(parsed.query).has_key('source'):
           self.source = urlparse.parse_qs(parsed.query)['source'].pop()
           
        if urlparse.parse_qs(parsed.query).has_key('destination'):
            self.destination = urlparse.parse_qs(parsed.query)['destination'].pop()
        
        return (self.source, self.destination)    
    
def main():
        print "Content-type: text/plain; charset=utf-8\n\n";
        #url = os.environ["REQUEST_URI"]
        if len(sys.argv) < 2:
            print "Error: passed arguments to FolderCopy cgi script are not corect"
            exit(-1)
        #url = os.environ["REQUEST_URI"]
        '''sys.arg[0] is FilerCopy.py'''        
        url = sys.argv[1]
        
        fileCopy=FileCopy()
        
        source, destination = fileCopy.parseURL(url)
                
        isParaValid = fileCopy.validateParameters()
        if isParaValid:
            fileCopy.copyFile(source, destination)

if __name__ == "__main__":
        main()