CREATE OR REPLACE VIEW WFS.VDW_PREPACK_REPORTS AS 
	SELECT  rti.provider_id AS provider_id,
		ptnr.name AS provider_name, 
		rti.document_id AS document_id, 
		rti.title_brief AS title_brief, 
		to_char(to_date(SUBSTR(rti.license_start_date, 1, 10), 'yyyy-MM-dd'), 'mm/dd/yyyy') AS License_start_date, 
		to_char(to_date(SUBSTR(rti.license_end_date, 1, 10), 'yyyy-MM-dd'), 'mm/dd/yyyy') AS license_end_date,
		rti.pkg_asset_id AS package_asset_Id, 
		rti.asset_count AS asset_count, 
		to_char(ttvtoken.startdate,'mm/dd/yyyy hh24:mi:ss') AS wo_start_datetime, 
		to_date(TO_CHAR(ttvtoken.startdate,'yyyy-mm-dd'),'yyyy-mm-dd') AS wo_start, 
		to_date(TO_CHAR(ttvtoken.enddate,'yyyy-mm-dd'),'yyyy-mm-dd') AS wo_end, 
		to_char(extract(day FROM token.enddate - ttvtoken.startdate), '0000') || to_char(token.enddate - ttvtoken.startdate,' HH24:MI:SS') AS work_order_time, 
		rti.title_id AS title_id, 
		pi.processid AS work_order_id,
		token.operationalstatus AS work_order_status_id,
		CASE  WHEN ps.name ='STOPPED' THEN  'COMPLETE'  WHEN ps.name ='ERROR' THEN  'FAIL'  ELSE ps.name  END AS work_order_status,
		pi.isactive AS is_work_order_active, 
		template.id AS template_id, 
		template.name AS template_name, 
		rti.site_name AS site_distn_site_name, 
		3 AS site_distn_status_id, 
		'DISTRIBUTED' AS site_distn_status, 
		1 AS provider_title_cnt,
		rti.title_asset_Id AS title_asset_Id,
		rti.title_display AS title_display,
		rti.app_type AS app_type, 
		rti.price AS price
	FROM wfs.ttv_processinstance  pi  
		LEFT OUTER  JOIN wfs.Prepack_Report_TitleInfo rti 
		ON (rti.workorder_id = pi.processid)	
		JOIN wfs.ttv_token ttvtoken ON  (ttvtoken.tokenid = pi.roottokenid) 
		JOIN wfs.ttv_processinstance pis ON (rti.final_workorder_id = pis.processid)
		JOIN wfs.ttv_token token  ON (token.tokenid = pis.roottokenid)
		JOIN wfs.pmm_partner ptnr ON (ptnr.providerid = rti.provider_id) 
		JOIN wfs.ttv_template template  ON (template.id = pi.templateid) 
		JOIN wfs.ttv_processstatus ps  ON (ps.processstatusid = token.operationalstatus )
	             
	 	