#!/bin/sh
#
# Copyright (c) 2018 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Taurus Zhang
# Created: Jan 24th, 2018
# Description:
# Use Shell to do additional jobs after installation is done, mainly for upgrading.
#


CL30IdMappingFile='/opt/tandbergtv/cms/plugins/content/com.ericsson.metadatamanager.specimpl.cl3_0/resources/mapping.dat'
if [ -f "$CL30IdMappingFile" ]
then
	sed -i "s/ADI3\/Offer\/@uriId/ADI3\/Asset[@xsi:type=\'offer:OfferType\']\/@uriId/g" $CL30IdMappingFile
else
	echo "File does not exist: $CL30IdMappingFile"
fi

DefaultIdMappingFile='/opt/tandbergtv/cms/workflow/plugins/subsystems/content-management-additional/resources/properties/DefaultIdentifiersMapping.dat'
if [ -f "$DefaultIdMappingFile" ]
then
        if grep -Fxq "[CL3_0]" $DefaultIdMappingFile
        then
            echo "CL3_0 mapping has been added."
        else
            echo "" >> $DefaultIdMappingFile
            echo "[CL3_0]" >> $DefaultIdMappingFile
            echo "ADI3/Asset[@xsi:type='offer:OfferType']/@uriId, /Fields/CustomFields/CustomField[@name=OfferUriId]/@value" >> $DefaultIdMappingFile
        fi
else
	echo "File does not exist: $DefaultIdMappingFile"
fi

