with base as (
select * from tre_predicate predicate
left join tre_expnode node on node.predicateid = predicate.predicateid
where predicate.fieldleft in (
'/Fields/CustomFields/CustomField[@name=VideoRate]/@value',
'/Fields/CustomFields/CustomField[@name=TransportRate]/@value',
'/Fields/CustomFields/CustomField[@name=VideoCBR]/@value',
'/Fields/CustomFields/CustomField[@name=RunTime]/@value')
 or predicate.fieldright in (
'/Fields/CustomFields/CustomField[@name=VideoRate]/@value',
'/Fields/CustomFields/CustomField[@name=TransportRate]/@value',
'/Fields/CustomFields/CustomField[@name=VideoCBR]/@value',
'/Fields/CustomFields/CustomField[@name=RunTime]/@value')
)
,
predicate as (
select distinct 'ruleId: '||trs.rulesetid id,tp.name ruleType, trs.rulename as name
from tre_ruleset trs
join tre_rule tr on trs.rulesetid = tr.rulesetid
join base on base.parentid = tr.rootnodeid
join tre_package tp on trs.packageid = tp.packageid
),
filter as (
select distinct 'ruleId: '||ruleset.rulesetid id,tp.name ruleType, ruleset.rulename as name
from tre_ruleset ruleset
join tre_titlefilter tf on ruleset.titlefilterid = tf.titlefilterid
join tre_expnode pNode on coalesce(pnode.parentid,pnode.nodeid) = tf.rootnodeid
join base on base.parentid = pNode.nodeid
join tre_package tp on ruleset.packageid = tp.packageid
),
titleSearch as(
select distinct 'searchId: '||ts.titlesearchid id,'Content->Search' ruleType, ts.name
from tre_titlesearch ts
join tre_titlefilter tf on ts.titlefilterid = tf.titlefilterid
join tre_expnode pNode on coalesce(pnode.parentid,pnode.nodeid) = tf.rootnodeid
join base on base.parentid = pNode.nodeid
)
select * from (select * from predicate union  select * from filter union  select * from titleSearch)

union

select distinct 'ruleId: '|| trs.rulesetid id, tp.name ruleType, trs.rulename as name
from tre_actionparametervalue apv
join tre_action ta on ta.actionid = apv.actionid
join tre_rule tr on tr.ruleid = ta.ruleid
join tre_ruleset trs on trs.rulesetid = tr.rulesetid
left join tre_package tp on trs.packageid = tp.packageid
where apv.value in (
'/Fields/CustomFields/CustomField[@name=VideoRate]/@value',
'/Fields/CustomFields/CustomField[@name=TransportRate]/@value',
'/Fields/CustomFields/CustomField[@name=VideoCBR]/@value',
'/Fields/CustomFields/CustomField[@name=RunTime]/@value'
)
order by ruletype

