create or replace view wfs.title_distribution_info  as        	 
	(SELECT distinct rti.provider_id as provider_id, 
		ptnr.name as provider_name, 
		rti.document_id as document_id,
		rti.title_brief as title_brief,
		REPLACE(rti.license_start_date, 'T', ' ') as License_start_date,
		REPLACE(rti.license_end_date, 'T', ' ') as License_end_date, 
		rti.pkg_asset_id as Package_AssetID,
		rti.asset_count as asset_count,
		'Media Transcoded' as wo_status,  
		to_date(to_char(ttvtoken.startdate,'yyyy-mm-dd'),'yyyy-mm-dd')  as wo_start,
		to_date(to_char(ttvtoken.enddate ,'yyyy-mm-dd'),'yyyy-mm-dd') as wo_end, 
		to_char(extract(day from ttvtoken.enddate - ttvtoken.startdate), '0000') || to_char(ttvtoken.enddate - ttvtoken.startdate,' HH24:MI:SS') completion_time,
		round(extract(second from (ttvtoken.enddate - ttvtoken.startdate)) + extract(minute from (ttvtoken.enddate - ttvtoken.startdate))*60 + extract(hour from (ttvtoken.enddate - ttvtoken.startdate))*60*60 + extract(day from (ttvtoken.enddate - ttvtoken.startdate))*60*60*24) as completion_time_seconds	
	FROM    wfs.ttv_processinstance  pi ,			  
		 wfs.Prepack_Report_TitleInfo rti,
		 wfs.ttv_token ttvtoken ,
		 wfs.pmm_partner ptnr,
		 wfs.ttv_template template, 
		 wfs.ttv_processstatus ps		
	where  rti.workorder_id = pi.processid
		and   ptnr.providerid = rti.provider_id		  
		and   ttvtoken.tokenid = pi.roottokenid		
		and   ttvtoken.operationalstatus =  ps.processstatusid 
		and   template.id = pi.templateid
		and  template.name='Azuki Distribution Template')
union all 
	(SELECT distinct rti.provider_id as provider_id,
		ptnr.name as provider_name, 
		rti.document_id as document_id, 
		rti.title_brief as title_brief, 
		REPLACE(rti.license_start_date,'T',' ') as License_start_date,
		REPLACE(rti.license_end_date, 'T', ' ') as License_end_date, 
		rti.pkg_asset_id as Package_AssetID, 
		rti.asset_count as asset_count, 
		'Media Transcoded' as wo_status, 
		to_date(to_char(ttvtoken.startdate,'yyyy-mm-dd'),'yyyy-mm-dd')  as wo_start,
		to_date(to_char(ttvtoken.enddate ,'yyyy-mm-dd'),'yyyy-mm-dd') as wo_end,    
		to_char(extract(day from ttvtoken.enddate - ttvtoken.startdate), '0000') || to_char(ttvtoken.enddate - ttvtoken.startdate,' HH24:MI:SS') completion_time,
		round(extract(second from (ttvtoken.enddate - ttvtoken.startdate)) + extract(minute from (ttvtoken.enddate - ttvtoken.startdate))*60 + extract(hour from (ttvtoken.enddate - ttvtoken.startdate))*60*60 + extract(day from (ttvtoken.enddate - ttvtoken.startdate))*60*60*24) as completion_time_seconds	
	FROM   wfs.ttv_processinstance  pi ,			  
		 wfs.Prepack_Report_TitleInfo rti,
		 wfs.ttv_token ttvtoken ,
		 wfs.ttv_processinstance pis,
		 wfs.ttv_token token,
		 wfs.pmm_partner ptnr,
		 wfs.ttv_template template, 
		 wfs.ttv_processstatus ps			
	where  rti.workorder_id = pi.processid
		and   ttvtoken.tokenid = pi.roottokenid		    
		and   token.tokenid = pis.roottokenid		  
		and  pis.roottokenid = token.parenttokenid  
		and  ptnr.providerid = rti.provider_id
		and token.operationalstatus = ps.processstatusid  		   
		and template.id = pi.templateid
		and  template.name='Distribute Metadata to Azuki')
