CREATE OR REPLACE VIEW wfs.VDW_PREPACK_PURGE_REPORTS AS 
	SELECT DISTINCT  rti.title_brief AS title_brief, 
		rti.provider_id AS provider_id, 
		ptnr.name AS provider_name, 
		to_date(SUBSTR(rti.license_start_date, 1, 10), 'yyyy-MM-dd') AS License_start_date, 
		to_date(SUBSTR(rti.license_end_date, 1, 10), 'yyyy-MM-dd') AS License_end_date, 
		rti.asset_count AS asset_count,
		rti.pkg_asset_id AS package_asset_id,
		token.operationalstatus AS work_order_status_id,
		CASE  WHEN ps.name ='STOPPED' THEN  'COMPLETE'  WHEN ps.name ='ERROR' THEN  'FAIL'  ELSE ps.name  END AS work_order_status, 
		pi.isactive AS is_work_order_active,
		template.name  AS template_name,
		to_char(ttvtoken.startdate,'mm/dd/yyyy hh24:mi:ss') AS wo_start_datetime,
		to_date(TO_CHAR(ttvtoken.startdate,'yyyy-mm-dd'),'yyyy-mm-dd') AS wo_start,
		to_date(TO_CHAR(ttvtoken.enddate,'yyyy-mm-dd'),'yyyy-mm-dd') AS wo_end,
		to_char(extract(day FROM token.enddate - ttvtoken.startdate), '0000') || to_char(token.enddate - ttvtoken.startdate,' HH24:MI:SS') AS work_order_time,
		1 AS Provider_Title_Cnt,
		rti.site_name AS site_name,
		rti.title_id AS title_id
	FROM wfs.ttv_processinstance pi 
		LEFT OUTER  JOIN wfs.Prepack_Report_TitleInfo rti  ON (rti.workorder_id = pi.processid) 
		JOIN wfs.ttv_token ttvtoken  ON  (ttvtoken.tokenid = pi.roottokenid) 
		JOIN wfs.ttv_processinstance pis  ON (rti.final_workorder_id = pis.processid) 
		JOIN wfs.ttv_token token  ON (token.tokenid = pis.roottokenid) 
		JOIN wfs.pmm_partner ptnr  ON (ptnr.providerid = rti.provider_id)  
		JOIN wfs.ttv_template template  ON (template.id = pi.templateid) 
		JOIN ttv_processstatus ps  ON (token.operationalstatus = ps.processstatusid)

 	