/*
 * Data patch for rule operator correction for "CL11_BOX COVER - Check fields format", "CL11_TITLE - Check fields format"
 * Purpose: calculate length of field for each asset individually.
 * Author: Jane on 7th DEC 2016
* Modified script to plpgsql by Suresh Neravati on 08/23/2017
 */
DO $$
DECLARE
   recursor_ruleset cursor FOR SELECT RULESETID,RULENAME from TRE_RULESET t
                              where PACKAGEID=(SELECT PACKAGEID from TRE_PACKAGE where NAME='VALIDATION')
                              and (t.RULENAME='CL11_BOX COVER - Check fields format' or t.RULENAME='CL11_TITLE - Check fields format');

   t_packageid      numeric(10,0);
   t_rulesetid      numeric(10,0);
   t_ruleid         numeric(10,0);
   rulesetname      text;
   t_rootnodeid     numeric(10,0);
   recursor_rule    cursor FOR SELECT ruleid,rootnodeid from TRE_RULE t where rulesetid=t_rulesetid;
   
BEGIN
   OPEN recursor_ruleset;
   LOOP
     FETCH recursor_ruleset INTO t_rulesetid,rulesetname;
     RAISE NOTICE 'processing rule: %, rulesetid: %', rulesetname, t_rulesetid;
     EXIT WHEN NOT FOUND;
     OPEN recursor_rule;
     LOOP
       FETCH recursor_rule INTO t_ruleid,t_rootnodeid;
       EXIT WHEN NOT FOUND;
       RAISE NOTICE '   root node id is: %, t_rootnodeid: %', t_ruleid, t_rootnodeid;
       IF (rulesetname = 'CL11_BOX COVER - Check fields format') THEN
           update TRE_PREDICATE set OPERATOR ='LENGTHGREATERTHAN' 
            where PREDICATEID in (SELECT PREDICATEID from TRE_EXPNODE exp where PARENTID=t_rootnodeid 
                                     and exists (SELECT * from TRE_PREDICATE pre 
                                                  where pre.FIELDLEFT='/Fields/ProductInfo/Name' 
                                                    and pre.fieldleftsectiontype='PACKAGE/BOXCOVER' 
                                                    and pre.OPERATOR ='TOTALLENGTHGREATERTHAN'  
                                                    and pre.PREDICATEID=exp.PREDICATEID)); 
       END IF;
       IF rulesetname='CL11_TITLE - Check fields format' THEN
        update TRE_PREDICATE set OPERATOR ='LENGTHGREATERTHAN' 
                    where PREDICATEID in ( SELECT PREDICATEID from TRE_EXPNODE exp where PARENTID=t_rootnodeid 
                                              and exists (SELECT * from TRE_PREDICATE pre where pre.FIELDLEFT='/Fields/CreationInfo/Studio/Code' 
                                                             and pre.fieldleftsectiontype='PACKAGE/TITLE' 
                                                             and pre.OPERATOR ='TOTALLENGTHGREATERTHAN'  
                                                             and pre.PREDICATEID = exp.PREDICATEID)
                ); 
       END IF;
      END LOOP;
      CLOSE recursor_rule;
   END LOOP;
   CLOSE recursor_ruleset;
END;
$$ language plpgsql;
