#!/bin/bash
#
# Copyright (c) 2013 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Simon Meng
# Created: Jul 26, 2013
# Description:
# A script for install/update cms cron job(s)

sudo echo "Install cron job begin..."


datestamp=`date '+%Y%m%d%H%M%S'`

HOUSEKEEP_CRON_EXP="0 0 * * *"
HOUSEKEEP_CMD=cms-file-housekeep.sh
HOUSEKEEP_CMD_PATH=/opt/tandbergtv/cms/cronjob/cms-file-housekeep.sh


sudo chown nobody:nobody $HOUSEKEEP_CMD_PATH
sudo chmod +x $HOUSEKEEP_CMD_PATH
sudo sh -c  "crontab -u nobody -l > /tmp/cron.${datestamp}"
sudo cp /tmp/cron.${datestamp} /tmp/cron.${datestamp}.bak

sudo sed -i "s/.*${HOUSEKEEP_CMD}.*//g"  /tmp/cron.${datestamp}
sudo sed -i '/^$/d' /tmp/cron.${datestamp}
sudo sh -c  "echo \"${HOUSEKEEP_CRON_EXP} ${HOUSEKEEP_CMD_PATH}\" >> /tmp/cron.${datestamp}"

sudo crontab -u nobody /tmp/cron.${datestamp}

sudo echo "Install cron job done"

exit;
