#!/bin/sh
LIBAIO_RPM=libaio-0.3.107-10.x86_64.rpm

## Oracle database lib
ORACLE_CLIENT_RPM=oracle-instantclient11.2-basic-11.2.0.3.0-1.x86_64.rpm
ORACLE_CLIENT_SQLPLUS_RPM=oracle-instantclient11.2-sqlplus-11.2.0.3.0-1.x86_64.rpm
CX_ORACLE_RPM=cx_Oracle-5.1.2-11g-py26-1.x86_64.rpm

## EDB database lib
EDB_CLIENT_RPM=postgresql93-libs-9.3rc1-1PGDG.rhel6.x86_64.rpm
EDB_LIB_RPM=python-psycopg2-2.0.14-2.el6.x86_64.rpm

HTTPLIB2_RPM=python-httplib2-0.7.4-6.el6.noarch.rpm

LD_LIBRARY_PATH_VAR=/usr/lib/oracle/11.2/client64/lib
ORACLE_HOME_VAR=/usr/lib/oracle/11.2/client64

isCMS4_0=$1
################################################################

if [ "$isCMS4_0" == true ]; then   
   declare -a RPMS=($LIBAIO_RPM $HTTPLIB2_RPM $EDB_CLIENT_RPM $EDB_LIB_RPM)   
else
   declare -a RPMS=($LIBAIO_RPM $ORACLE_CLIENT_RPM $ORACLE_CLIENT_SQLPLUS_RPM $CX_ORACLE_RPM $HTTPLIB2_RPM)
fi

for r in "${RPMS[@]}"
do
   sudo rpm -qa | sudo grep ${r%.rpm} || sudo rpm -ivh $r
done
   
if [ "$isCMS4_0" == false ]
then
   DB_USER=wfs
   DB_PASS="Wf\$1234"
   DB_TNS=dbserver
   
   sudo grep LD_LIBRARY_PATH /etc/bashrc > /dev/null ||sudo sh -c "echo export LD_LIBRARY_PATH=$LD_LIBRARY_PATH_VAR >> /etc/bashrc" && export LD_LIBRARY_PATH=$LD_LIBRARY_PATH_VAR
   sudo grep ORACLE_HOME /etc/bashrc > /dev/null || sudo sh -c "echo export ORACLE_HOME=$ORACLE_HOME_VAR >> /etc/bashrc" && export ORACLE_HOME=$ORACLE_HOME_VAR
   
   sudo mkdir -p $ORACLE_HOME/network/admin
   
   if [ ! -e $ORACLE_HOME/network/admin/tnsnames.ora ]
   then
   	sudo cp tnsnames.ora $ORACLE_HOME/network/admin/tnsnames.ora
   fi
   
   sudo python -c "print __import__('cx_Oracle').connect('wfs/Wf\$1234@dbserver').version" > /dev/null && sudo echo "cx_Oracle installation successful." || sudo echo "cx_Oracle installation failed."

fi


