#!/bin/sh

# this bootstraps the python dependency
# after running once and getting a new shell, you can use
#    ./scripts/deploy.py -i XXX.json

source ./scripts/verifyUserSudoConfig.sh

################################################################
## Get CMS version
################################################################
version=`sudo rpm -qi watchpoint-cms  | sudo grep Version | sudo awk '{print $3}'`

majorVersion=${version:0:3}

sudo echo "CMS version is $majorVersion"

################################################################
## Set LOG Environment
################################################################
sudo grep LOG /etc/bashrc > /dev/null || sudo sh -c 'echo export LOG=/opt/tandbergtv/log/jboss.log >> /etc/bashrc'

cd pysetup
sh ./pysetup.sh true 
source /etc/bashrc
cd ..

#####################################################################
## Upgrade 4.5-4.6 : Move Aspera from XPMP to Devices
#####################################################################
folder="./4.5-4.6/"
if [ -d "$folder" ]; then
  sh ./4.5-4.6/updateInstalledComponent.sh
fi

preprocessParams=" -v $majorVersion -i install_sysInfo.json"
inputParams=$@
inputParams+=$preprocessParams

source ./get_cluster_info.sh
setOptionValues $inputParams
echo "Start to perfrom ip address auto feed in..."
autoIpFeedIn
echo
echo "Start to verify password...."
promptForPwdInput

echo
echo "Ready to execute prepack installer..."
sudo python ./scripts/install.pyc -i install_sysInfo.json -m UPGRADE -u $currentUser -w $password $inputParams

cd pysetup
sh ./pyunstall.sh true 
