<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn">
<xsl:import href="from/common.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Group[@type = 'PREVIEW']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">
					<xsl:choose>
						<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">preview</xsl:when>
						<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</AMS>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Type</xsl:attribute>
				<xsl:attribute name="Value">preview</xsl:attribute>
			</App_Data>
			<xsl:for-each select="tns:Fields/tns:Video/tns:TrickModesRestricted">
				<App_Data>
					<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
					<xsl:attribute name="Name">trickModesRestricted</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Rating/tns:Value">
				<App_Data>
					<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
					<xsl:attribute name="Name">Rating</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Rating/tns:MSORating">
				<App_Data>
					<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
					<xsl:attribute name="Name">MSORating</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Rating/tns:TargetAudience">
				<App_Data>
					<xsl:attribute name="App"><xsl:value-of select="../../tns:ApplicationInfo/tns:Name" /></xsl:attribute>
					<xsl:attribute name="Name">Audience</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet RunTimeAttribute" />
			<xsl:for-each select="tns:Fields/tns:Audio">
				<App_Data>
					<xsl:attribute name="App">
						<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
					</xsl:attribute>
					<xsl:attribute name="Name">Audio_Type</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Type" />
					</xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:if test="tns:Fields/tns:Video/tns:ScreenFormat">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ScreenFormatAttribute" />
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Video/tns:HDContent">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet HDContentAttribute" />
			</xsl:if>
			<xsl:for-each select="tns:Fields/tns:Language">
				<App_Data>
					<xsl:attribute name="App">
						<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
					</xsl:attribute>
					<xsl:attribute name="Name">Languages</xsl:attribute>
					<xsl:attribute name="Value">
				    	<xsl:value-of select="@value" />
					</xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:SubTitleLanguage">
				<App_Data>
					<xsl:attribute name="App">
						<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
					</xsl:attribute>
					<xsl:attribute name="Name">Subtitle_Languages</xsl:attribute>
					<xsl:attribute name="Value">
				    	<xsl:value-of select="@value" />
					</xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:DubbedLanguage">
				<App_Data>
					<xsl:attribute name="App">
						<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
					</xsl:attribute>
					<xsl:attribute name="Name">Dubbed_Languages</xsl:attribute>
					<xsl:attribute name="Value">
				    	<xsl:value-of select="@value" />
					</xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:if test="tns:Fields/tns:Video/tns:BitRate">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet BitRateAttribute" />
			</xsl:if>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFileSizeAttribute" />
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentChecksumAttribute" />
			
			<xsl:if test="tns:Fields/tns:Content/tns:Resolution" >
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentResolution" />
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:FrameRate" >
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFrameRate" />
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:Codec" >
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentCodec" />
			</xsl:if>		
			
			<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		</Metadata>
		<xsl:if test="tns:Fields/tns:Content/tns:Locator/tns:Uri != ''" >
			<Content xsl:use-attribute-sets="ContentAttributeSet" />
		</xsl:if>
	</Asset>
</xsl:template>


</xsl:stylesheet>