#!/bin/sh

PREFERENCES_PATH="/opt/tandbergtv/cms/workflow/preferences"
SUBSYSTEMS_PATH="/opt/tandbergtv/cms/plugins/workflow/plugins/subsystems"
GROUPS_PATH="/opt/tandbergtv/cms/plugins/workflow/plugins/groups"

deprecateFolderPath="${GROUPS_PATH}/notification-resourcetype"
MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"

patternMappingProperties="${SUBSYSTEMS_PATH}/content-management-additional/resources/properties/PatternMapping.properties"
maResourceTypeProperties="${SUBSYSTEMS_PATH}/content-management-additional/resources/properties/ResourceType.properties"
metadataUpdateConfig="${SUBSYSTEMS_PATH}/content-management-additional/resources/properties/metadata-update-config.xml"
metadataUpdateConfigForStandalone="${SUBSYSTEMS_PATH}/content-management-additional/resources/properties/metadata-update-config-for-standalone.xml"
notificationProfile="${PREFERENCES_PATH}/profiles/notification-profile.xml"
DEFAULT_CP_PROFILE_PATH="${PREFERENCES_PATH}/cp-profile/Default.xml"
DEFAULT_STATE_MACHINE_PROFILE_PATH="${PREFERENCES_PATH}/state-machine/Default.xml"
imageProcessingForMediaProfile="${PREFERENCES_PATH}/profiles/image-processing-for-media-profile.xml"
contentEvalutionProfile="${PREFERENCES_PATH}/profiles/content-evaluation.xml"
systemProfile="${PREFERENCES_PATH}/system.xml"
fileSystemLockProperties="${SUBSYSTEMS_PATH}/filesystem-lock/resources/properties/FileSystemLock.properties"
specAliasMappingProperties="${SUBSYSTEMS_PATH}/generic-metadata-parser/resources/properties/SpecAliasMapping.properties"
notificationProperties="${SUBSYSTEMS_PATH}/notification-resourcetype/resources/properties/Notification.properties"
purgeConfig="${PREFERENCES_PATH}/purge-config.xml"
envivioProperties="${SUBSYSTEMS_PATH}/envivio-adapter/resources/properties/envivio.properties"

contentArchivingState='<state name="Do_Content_Archiving">
  <transition name="completed" type="event">
    <nextState>Do_Targeting</nextState>
  </transition>
  <transition name="not_required" type="auto">
    <nextState>Do_Targeting</nextState>
  </transition>
</state>'

replicationState='<state name="Do_Replication">
  <transition name="completed" type="event">
    <nextState>Do_Offer_Processing</nextState>
  </transition>
  <transition name="not_required" type="auto">
    <nextState>Do_Offer_Processing</nextState>
  </transition>
</state>'

generatePosterProfile='<profile name="Generate_Poster">
  <template_name>Auto Generate Image From Video</template_name>
  <width></width>
  <height></height>
  <format>jpg</format>
  <new_asset_type>POSTER</new_asset_type>
  <execute-profile>thumbnail</execute-profile>
  <output-file-name>auto_thumbnail</output-file-name>
</profile>'

videoIndexState='<state name="Do_Video_Indexing">
  <transition name="completed" type="event">
     <nextState>Do_Image_Processing</nextState>
  </transition>
  <transition name="not_required" type="auto">
      <nextState>Do_Image_Processing</nextState>
  </transition>
</state>'

if [ -d "$deprecateFolderPath" ]; then
  rm -rf $deprecateFolderPath >/dev/null
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${patternMappingProperties} ]; then
  echo "Upgrading $patternMappingProperties"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${patternMappingProperties} -k PLATFORM -v "/Fields/CustomFields/CustomField[@name=Platform]/@value"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${patternMappingProperties} -k MF_PROGRAM_ID -v "/Fields/CustomFields/CustomField[@name=MF_Program_Id]/@value"
fi

if [ -f "$MIGRATION_TOOL_PATH" ] && [ -f ${notificationProfile} ]; then
  echo "Upgrading $notificationProfile"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${notificationProfile} -k /profiles/profile[@name=\"notification\"] -v "<additionalInfo name=\"programId\">{MF_PROGRAM_ID}</additionalInfo>"
fi

if [ -f $MIGRATION_TOOL_PATH ] && [ -f $DEFAULT_CP_PROFILE_PATH ]; then
  echo Doing upgrade on $DEFAULT_CP_PROFILE_PATH and $DEFAULT_STATE_MACHINE_PROFILE_PATH

  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"movie.archiveContent\">false</entry>"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"preview.archiveContent\">false</entry>"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"movie.ENVIVIO_MBR_HD.replication_platformList\">ENVIVIO_MBR_HD_RegionB</entry>"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"movie.ENVIVIO_MBR_HD_RegionB.replication_on_distribution\">false</entry>"
  python "${MIGRATION_TOOL_PATH}" -a REMOVE-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties/entry[@key=\"movie.qc_profile\"]
  python "${MIGRATION_TOOL_PATH}" -a REMOVE-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties/entry[@key=\"preview.qc_profile\"]
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"movie.qc_profile\">ffmpeg-qc</entry>"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"preview.qc_profile\">ffmpeg-qc</entry>"
  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $DEFAULT_CP_PROFILE_PATH -k /properties/entry[@key=\"movie.filePropertiesList\"] -v "encoding,videoRate,closedCaptioning,runTime,aspectRatio,resolution,videoFrameRate,actualVideoFrameRate,isHD,screenFormat,bitRate,audioType,displayRunTime"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"movie.video_index\">false</entry>"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"movie.video_index_profile\">Video_Indexing</entry>"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"preview.video_index\">false</entry>"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_CP_PROFILE_PATH -k /properties -v "<entry key=\"preview.video_index_profile\">Video_Indexing</entry>"


  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine/state[@name!=\'Do_Content_Archiving\']/transition[@name=\'completed\']/nextState[text\(\)=\'Do_Targeting\'] -v "Do_Content_Archiving"
  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine/state[@name!=\'Do_Content_Archiving\']/transition[@name=\"not_required\"]/nextState[text\(\)=\'Do_Targeting\'] -v "Do_Content_Archiving"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine -v "$contentArchivingState"
  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine/state[@name!=\'Do_Replication\']/transition[@name=\'completed\']/nextState[text\(\)=\'Do_Offer_Processing\'] -v "Do_Replication"
  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine/state[@name!=\'Do_Replication\']/transition[@name=\"not_required\"]/nextState[text\(\)=\'Do_Offer_Processing\'] -v "Do_Replication"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine -v "$replicationState"
  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine/state[@name!=\'Do_Video_Indexing\']/transition[@name=\'completed\']/nextState[text\(\)=\'Do_Image_Processing\'] -v "Do_Video_Indexing"
  python "${MIGRATION_TOOL_PATH}" -a REPLACE-ENTRY-VALUE -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine/state[@name!=\'Do_Video_Indexing\']/transition[@name=\"not_required\"]/nextState[text\(\)=\'Do_Image_Processing\'] -v "Do_Video_Indexing"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f $DEFAULT_STATE_MACHINE_PROFILE_PATH -k /statemachine -v "$videoIndexState"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${metadataUpdateConfig} ]; then
  echo Upgrading $metadataUpdateConfig
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfig} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW\" path=\"Archiving_Content_Required\" value=\"\"/>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfig} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW,ENCRYPTED,POSTER,BOXCOVER\" path=\"Replication_PlatformList\" value=\"\"/>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfig} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW,ENCRYPTED,POSTER,BOXCOVER\" path=\"Replication_On_Distribution\" value=\"\"/>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfig} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW,ENCRYPTED\" path=\"QC_Profile\" value=\"\"/>"
  python ${MIGRATION_TOOL_PATH} -a UPDATE-ENTRY-KEY -f ${metadataUpdateConfig} -k "/fields/field[@path=\"ImageProcess\"]/@assetTypes" -v "POSTER,BOXCOVER,MOVIE,PREVIEW"
  python ${MIGRATION_TOOL_PATH} -a UPDATE-ENTRY-KEY -f ${metadataUpdateConfig} -k "/fields/field[@path=\"ImageProcess_Profile\"]/@assetTypes" -v "POSTER,BOXCOVER,MOVIE,PREVIEW"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${metadataUpdateConfigForStandalone} ]; then
  echo Upgrading $metadataUpdateConfigForStandalone
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfigForStandalone} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW\" path=\"Archiving_Content_Required\" value=\"\"/>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfigForStandalone} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW,ENCRYPTED,POSTER,BOXCOVER\" path=\"Replication_PlatformList\" value=\"\"/>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfigForStandalone} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW,ENCRYPTED,POSTER,BOXCOVER\" path=\"Replication_On_Distribution\" value=\"\"/>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${metadataUpdateConfigForStandalone} -k /fields -v "<field isCustomField=\"true\" assetTypes=\"MOVIE,PREVIEW,ENCRYPTED\" path=\"QC_Profile\" value=\"\"/>"
  python ${MIGRATION_TOOL_PATH} -a UPDATE-ENTRY-KEY -f ${metadataUpdateConfigForStandalone} -k "/fields/field[@path=\"ImageProcess\"]/@assetTypes" -v "POSTER,BOXCOVER,MOVIE,PREVIEW"
  python ${MIGRATION_TOOL_PATH} -a UPDATE-ENTRY-KEY -f ${metadataUpdateConfigForStandalone} -k "/fields/field[@path=\"ImageProcess_Profile\"]/@assetTypes" -v "POSTER,BOXCOVER,MOVIE,PREVIEW"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${imageProcessingForMediaProfile} ]; then
  echo Upgrading $imageProcessingForMediaProfile
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${imageProcessingForMediaProfile} -k //profile[type[text\(\)=\"ExtractKeyFrames\"]] -v "<template_name>Generate Sprite Assets</template_name>"
  python ${MIGRATION_TOOL_PATH} -a REMOVE-ENTRY -f ${imageProcessingForMediaProfile} -k //type[text\(\)=\"ExtractKeyFrames\"]
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${imageProcessingForMediaProfile} -k /profiles -v "$generatePosterProfile"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${imageProcessingForMediaProfile} -k /profiles/profile/generated_asset -v "<density></density>"

fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${systemProfile} ]; then
  echo Upgrading $systemProfile
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${systemProfile} -k /properties -v "<entry key=\"cloud.storage.prefix\"></entry>"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${maResourceTypeProperties} ]; then
  echo Upgrading maResourceTypeProperties
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${maResourceTypeProperties} -k maximum.retry.times -v 5
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${maResourceTypeProperties} -k retry.period.seconds -v 10
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${fileSystemLockProperties} ]; then
  echo "Upgrading $fileSystemLockProperties"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${fileSystemLockProperties} -k metadata.specification.version -v "CableLabsVOD1.1,MSTV2,CableLabsVOD3.0,CableLabTVOD1.1"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${fileSystemLockProperties} -k CableLabsVOD1.1.alias -v "CL1_1"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${fileSystemLockProperties} -k MSTV2.alias -v "MSTV2"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${fileSystemLockProperties} -k CableLabsVOD3.0.alias -v "CL3_0"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${fileSystemLockProperties} -k CableLabTVOD1.1.alias -v "CL1_1"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${notificationProperties} ]; then
  echo "Upgrading $notificationProperties"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${notificationProperties} -k workorder.details.retry.max -v "3"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${notificationProperties} -k workorder.details.retry.interval.seconds -v "5"
fi

if [ -f "$specAliasMappingProperties" ]; then
  rm -f $specAliasMappingProperties >/dev/null
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${contentEvalutionProfile} ]; then
  echo "Upgrading $contentEvalutionProfile"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${contentEvalutionProfile} -k /profiles/profile[@name=\"ffmpeg-evaluation\"]/field-mappings -v "<field name=\"actualVideoFrameRate\">/Fields/Content/ActualFrameRate</field>"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${purgeConfig} ]; then
  echo "Upgrading $purgeConfig"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${purgeConfig} -k /properties -v "<entry key=\"purge.strategy.mediafirst.event\">Purge Live Event</entry>"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${envivioProperties} ]; then
  echo "Upgrading $envivioProperties"
  python ${MIGRATION_TOOL_PATH} -a APPEND-ENTRY-VALUE -f ${envivioProperties} -k "running.status" -v "muxing, garbage"
fi
