<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="tns">

	<xsl:template name="ancestorAssetType">
		<xsl:param name="assetId" />
		<xsl:for-each select="/tns:TTVSpec/tns:Group[@type = 'MOVIE' or @type = 'PREVIEW'] | /tns:TTVSpec/tns:Item[@type='ENCRYPTED']">
			<xsl:if test="tns:Fields/tns:Identifier/tns:Id and tns:Fields/tns:Identifier/tns:Id = $assetId">
				<xsl:choose>
					<xsl:when test="tns:Fields/tns:Derived/tns:SourceAssetId">
						<xsl:variable name="aat">
							<xsl:call-template name="ancestorAssetType">
								<xsl:with-param name="assetId" select="tns:Fields/tns:Derived/tns:SourceAssetId" />
							</xsl:call-template>
			        	</xsl:variable>
			        	<xsl:choose>
			        		<xsl:when test="$aat != ''">
			        			<xsl:value-of select="$aat" />
			        		</xsl:when>
			        		<xsl:otherwise>
			        			<xsl:apply-templates select="tns:Fields/tns:CustomFields/tns:CustomField[@name='ParentAssetType']" />
			        		</xsl:otherwise>
			        	</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="tns:Fields/tns:AssetClass" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="tns:Fields/tns:CustomFields/tns:CustomField[@name='ParentAssetType']">
		<xsl:value-of select="@value"/>
	</xsl:template>

</xsl:stylesheet>
