<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns">
    <xsl:output method="xml" indent="yes"/>
    <xsl:template name="labelInfo">
        <additionalInfo>
        <xsl:attribute name='name'>
        <xsl:text>Labels</xsl:text>
        </xsl:attribute>
        <xsl:for-each select="tns:Fields/tns:Labels/tns:Label">
                <xsl:variable name="labelName" select="./tns:Name/text()"/>
                
                  <!-- group Label by Label Name -->
                  <xsl:if test="not(preceding-sibling::*//tns:Name[text()=$labelName])">
                      <label>
	                      <name>
	                          <xsl:value-of select="$labelName" />
	                      </name>
	                      <values>
	                          <xsl:value-of select="./tns:Value/text()" />
	                      </values>
	                      <xsl:for-each select="following-sibling::*//tns:Name[text()=$labelName]">
	                          <values>
	                              <xsl:value-of select="parent::tns:Label/tns:Value/text()" />
	                          </values>
	                      </xsl:for-each>
	                      
	                      <!-- group Cultured Label by Cultured Key Name -->
	                      <xsl:for-each select="ancestor::tns:Fields/tns:CulturedLabels//tns:Name[text()=$labelName]">
	                          <xsl:variable name="culturedKeyName" select="parent::tns:CulturedLabel/tns:KeyName/text()"/>
	                          
	                          <xsl:if test="not(parent::tns:CulturedLabel/preceding-sibling::*//tns:KeyName[text()=$culturedKeyName])">
	                          <culturedKey>
	                              <xsl:attribute name='name'>
	                                  <xsl:value-of select="$culturedKeyName" />
	                              </xsl:attribute>
	                              <xsl:call-template name="generateCulturedValues">
                                       <xsl:with-param name="language" select="parent::tns:CulturedLabel/tns:Language/text()"/>
                                       <xsl:with-param name="culturedValues" select="parent::tns:CulturedLabel/tns:Value/text()"/>
                                  </xsl:call-template>
	                           <xsl:for-each select="parent::tns:CulturedLabel/following-sibling::*//tns:KeyName[text()=$culturedKeyName]">
	                               <xsl:call-template name="generateCulturedValues">
                                       <xsl:with-param name="language" select="parent::tns:CulturedLabel/tns:Language/text()"/>
                                       <xsl:with-param name="culturedValues" select="parent::tns:CulturedLabel/tns:Value/text()"/>
                                   </xsl:call-template>
	                           </xsl:for-each>
	                          </culturedKey>
	                          </xsl:if>
	                      </xsl:for-each>
                      </label>
                  </xsl:if>
        </xsl:for-each>
        </additionalInfo>
    </xsl:template>
    
    <xsl:template name="generateCulturedValues">
        <xsl:param name="language"/>
        <xsl:param name="culturedValues"/>
        <culturedValues>
            <xsl:attribute name='language'>
                <xsl:value-of select="$language" />
            </xsl:attribute>
            <xsl:value-of select="$culturedValues" />
        </culturedValues>
    </xsl:template>
</xsl:stylesheet>