#!/usr/bin/env python
#
# Copyright (c) 2012 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#

from DatabaseConnectionProvider import *
import os

class CMSVersionDeploymentPolicy(object):
    POLICY = None
    
    @staticmethod
    def getPrepackDepolymentPolicy():
        if CMSVersionDeploymentPolicy.POLICY is not None:
            return CMSVersionDeploymentPolicy.POLICY
        
        CMSVersionDeploymentPolicy.POLICY = PrepackDeploymentPolicy()
        return CMSVersionDeploymentPolicy.POLICY
        
class PrepackDeploymentPolicy(object):
    ENV_DB_WORKFLOW_SID = os.getenv("DB_WORKFLOW_SID")
    ENV_DB_WORKFLOW_HOST = os.getenv("DB_WORKFLOW_HOST")
    ENV_DB_WORKFLOW_PORT = os.getenv("DB_WORKFLOW_PORT")
    ENV_DB_WORKFLOW_USERNAME = os.getenv("DB_WORKFLOW_USERNAME")
    ENV_DB_WORKFLOW_PASSWORD = os.getenv("DB_WORKFLOW_PASSWORD")
    workflowDbProvider = None

    ENV_DB_CMS_SID = os.getenv("DB_CMS_SID")
    ENV_DB_CMS_HOST = os.getenv("DB_CMS_HOST")
    ENV_DB_CMS_PORT = os.getenv("DB_CMS_PORT")
    ENV_DB_CMS_USERNAME = os.getenv("DB_CMS_USERNAME")
    ENV_DB_CMS_PASSWORD = os.getenv("DB_CMS_PASSWORD")
    cmsDbProvider = None
    def getCmsDatabaseConnection(self):
        return PrepackDeploymentPolicy.cmsDbProvider.getCurrentConnection()
    
    def getWorkflowDatabaseConnection(self):
        return PrepackDeploymentPolicy.workflowDbProvider.getCurrentConnection()
    
    def cleanDatabaseConnection(self):
        if PrepackDeploymentPolicy.cmsDbProvider:
            PrepackDeploymentPolicy.cmsDbProvider.cleanCurrentConnection()
            
        if PrepackDeploymentPolicy.workflowDbProvider:
            PrepackDeploymentPolicy.workflowDbProvider.cleanCurrentConnection()

    def initDbProvider(self):
        PrepackDeploymentPolicy.cmsDbProvider = EDBDatabaseConnectionProvider(
            PrepackDeploymentPolicy.ENV_DB_CMS_SID,
            PrepackDeploymentPolicy.ENV_DB_CMS_USERNAME,
            PrepackDeploymentPolicy.ENV_DB_CMS_PASSWORD,
            PrepackDeploymentPolicy.ENV_DB_CMS_HOST,
            PrepackDeploymentPolicy.ENV_DB_CMS_PORT
        )
        PrepackDeploymentPolicy.workflowDbProvider = EDBDatabaseConnectionProvider(
            PrepackDeploymentPolicy.ENV_DB_WORKFLOW_SID,
            PrepackDeploymentPolicy.ENV_DB_WORKFLOW_USERNAME,
            PrepackDeploymentPolicy.ENV_DB_WORKFLOW_PASSWORD,
            PrepackDeploymentPolicy.ENV_DB_WORKFLOW_HOST,
            PrepackDeploymentPolicy.ENV_DB_WORKFLOW_PORT
        )

def main():
    policy = CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy()
    policy.getCmsDatabaseConnection()
    print type(policy).__name__
        
if __name__ == "__main__":
    main()        
