#!/usr/bin/env python
#
# Copyright (c) 2012 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Jerish Lin
# Created: Oct 17, 2013
# Description:
# Common base class

import sys

reload(sys)
sys.setdefaultencoding("utf-8")

from Alerts import Alerts
import CustomFields
import CustomFieldsGroups
import PartnersRestMgr
import ProcessDefinitions
import MeSubsProfile
import MeSubsProfileParameter
import MeIdentifierCriteria
import MeEnhancedField
import EnhancementRuleset
import ResourceGroupsRestMgr
import RulesetsRestMgr
import SitesRestMgr
import json
import os
import shutil
import socket
import time
import SelectorKeyRestMgr
from InstallHelper import InstallHelper
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy
from APPService import *
from SiteConstants import *
import ResourcesRestMgr

KEY_NAME = "PREPACK_NAME"
KEY_VERSION = "PREPACK_VERSION"


class Common(object):
    COMPONENTS_PATH_PREFIX = ""

    ITEM_KEYS = {
        "PARTNER":{"keys":["PROVIDERID","NAME","PARTNERTYPE","CONTENTCLASSNAME"],"uniqueKeys":["PROVIDERID"],"jsonKey":"partners"},
        "PARTNER_CONTENTCLASS":{"keys":[],"uniqueKeys":[],"jsonKey":"CONTENTCLASSNAME","parent":"PARTNER","mergeNeeded":True},
        "SITE": {"keys": [SITE_NAME, SITE_EXTERNALID, SITE_ACTIVE, SITE_DISTRIBUTION_OPTION, SITE_METADATA_FORMAT,
                          SITE_FILE_LOOKUP_KEYS, SITE_DIST_TEMPLATE_NAME, SITE_ALERT_DELAY_PERIOD, SITE_TYPE,
                          SITE_ASSOCIATE_RESOURCE, SITE_PARAMETERS, SITE_PARTIAL_OFFER_DISTRIBUTION,
                          SITE_PARTIAL_DEPENDS_ON_DISTRIBUTION, SITE_DEPENDS_ON_SITE, SITE_MONITORED_RESOURCES, SITE_DISTRIBUTION_STATUS_PLUGIN],
                 "uniqueKeys": [SITE_NAME], "jsonKey": "sites"},
        "UPDATESITE": {"keys": [SITE_NAME, SITE_FIELDS_TO_UPDATE], "uniqueKeys": [SITE_NAME], "jsonKey": "updateSites"},
        "SELECOTRKEY":{"keys":["SELECTIONKEY","TEMPLATE"],"uniqueKeys":["SELECTIONKEY","TEMPLATE"],"jsonKey":"selectorKeys"},
        "RESOURCE":{"keys":["NAME","RESOURCETYPENAME","RESOURCEGROUPNAME","CONNECTIONSTRING","MAXCONCURRENTUSERS","HEARTBEATCONNECTIONSTRING","HEARTBEATFREQUENCY","USERNAME"],"uniqueKeys":["NAME"],"jsonKey":"resources"},
        "RESOURCESONAPP":{"keys":["NAME","RESOURCETYPENAME","RESOURCEGROUPNAME","CONNECTIONSTRING","MAXCONCURRENTUSERS","HEARTBEATCONNECTIONSTRING","HEARTBEATFREQUENCY","USERNAME"],"uniqueKeys":["NAME"],"jsonKey":"resourcesOnApp"},
        "RESOURCESONCT":{"keys":["NAME","RESOURCETYPENAME","RESOURCEGROUPNAME","CONNECTIONSTRING","MAXCONCURRENTUSERS","HEARTBEATCONNECTIONSTRING","HEARTBEATFREQUENCY","USERNAME"],"uniqueKeys":["NAME"],"jsonKey":"resourcesOnCT"},
        "CUSTOMFIELDGROUP":{"keys":["DISPLAY_NAME","ASSET_PATH","UUID","FIELDS"],"uniqueKeys":["DISPLAY_NAME","ASSET_PATH"],"jsonKey":"customFields"},
        "CUSTOMFIELD":{"keys":["NAME","DATA_TYPE","JOB_PARAMETER","JOB_SCHEDULE_PARAMETER","DISPLAY_NAME","MULTIVALUE","FIELD_TYPE",],"uniqueKeys":["NAME"],"jsonKey":"FIELDS","parent":"CUSTOMFIELDGROUP","mergeNeeded":True},
        "ALERTNAME":{"keys":["ALERT_NAME","PATTERN","ALERTS"],"uniqueKeys":["ALERT_NAME"],"jsonKey":"alerts"},
        "ALERT":{"keys":["IDENTIFIER","THRESH_COUNT","THRESH_SECS","FREQ_COUNT","FREQ_SECS","SNMP_TRAP","EMAIL"],"uniqueKeys":["IDENTIFIER"],"jsonKey":"ALERTS","parent":"ALERTNAME"},
        "CONTENTCLASSES":{"keys":["NAME","DESCRIPTION","CONTENTCLASSFILES"],"uniqueKeys":["NAME"],"jsonKey":"contentClasses"},
        "CONTENTCLASSFILES":{"keys":["FILENAME",],"uniqueKeys":["FILENAME"],"jsonKey":"CONTENTCLASSFILES","parent":"CONTENTCLASSES","mergeNeeded":True},
        "CONTENTCLASSESTODELETE":{"keys":["NAME","DESCRIPTION","CONTENTCLASSFILES"],"uniqueKeys":["NAME"],"jsonKey":"contentClassesToDelete"},
        "CONTENTCLASSFILESTODELETE":{"keys":["FILENAME",],"uniqueKeys":["FILENAME"],"jsonKey":"CONTENTCLASSFILES","parent":"CONTENTCLASSESTODELETE","mergeNeeded":True},
        "RESOURCEHOSTS":{"keys":["NAME","VALUE"],"uniqueKeys":["NAME"],"jsonKey":"resourceHosts"},
        "WATCHFOLDER":{"keys":["path","filter","frequency","processClass","messageUID","commandParameter","messageParameter", "routingDir","failureDir","looseFileNamePattern","events","threads"],"uniqueKeys":["path","filter"],"jsonKey":"watchfolders"},
        "DISTTEMPLATE":{"keys":["NAME","GROUPS"],"uniqueKeys":["NAME"],"jsonKey":"distTemplates"},
        "FTPCONFIG":{"keys":["HOST","USER","PASSWORD"],"uniqueKeys":["HOST"],"jsonKey":"ftpConfig"},
        "PROVIDERPROPRETIES":{"keys":["secretKey","secretValues"],"uniqueKeys":["secretKey"],"jsonKey":"mePluginApiKey"},
        "PARAMS":{"keys":["NAME","VALUE"],"uniqueKeys":["NAME"],"jsonKey":"params"},

        "MESUBSPROFILE":{"keys":["NAME","PLUGIN_NAME","CRITERIA","ENHANCEDFIELD","PARAMETER"],"uniqueKeys":["NAME"],"jsonKey":"meprofiles"},
        "CRITERIA":{"keys":["NAME","MAPPING","DATATYPE","PATH","ASSET_TYPE","VALUE_FIELD_PATH"],"uniqueKeys":["NAME"],"jsonKey":"CRITERIA","parent":"MESUBSPROFILE","mergeNeeded":True},
        "ENHANCEDFIELD":{"keys":["NAME","MAPPING","DATATYPE","PATH"],"uniqueKeys":["NAME"],"jsonKey":"ENHANCEDFIELD","parent":"MESUBSPROFILE","mergeNeeded":True},
        "PARAMETER":{"keys":["NAME","VALUE"],"uniqueKeys":["NAME"],"jsonKey":"PARAMETER","parent":"MESUBSPROFILE","mergeNeeded":True}
    }

    def __init__(self):
        self.config = {}
        self.name = ""
        self.installerVersion = ""
        self.backupVersion = ""
        self.helper = InstallHelper()
        self.name = os.getenv(KEY_NAME) if os.getenv(KEY_NAME) else "CMS PrePack"
        self.installerVersion = os.getenv(KEY_VERSION)

    def initPolicy(self):
        CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().initDbProvider()

    def initParameters(self):
        self.wrapAllConfigWithFullAttributes()

    def findItemKeyByJsonKey(self, jsonKey):
        for keyType in self.ITEM_KEYS:
            if jsonKey == self.ITEM_KEYS[keyType]["jsonKey"]:
                return (keyType, self.ITEM_KEYS[keyType])
        return (None, None)

    def findItemKeysByParent(self, parent):
        itemKeyList = []
        for keyType in self.ITEM_KEYS:
            if self.ITEM_KEYS[keyType].has_key("parent") and parent == self.ITEM_KEYS[keyType]["parent"]:
                itemKeyList.append((keyType, self.ITEM_KEYS[keyType]))
        return itemKeyList

    def compareItemWithKey(self, attr, item1, item2):
        keyType, itemKeys = self.findItemKeyByJsonKey(attr)

        keyColumn = None
        if itemKeys:
            keyColumn = itemKeys["uniqueKeys"]
        else:
            keyColumn = item1
        for column in keyColumn:
            if item1[column] != item2[column]:
                return False
        return True

    def findItemInList(self, attr, item, itemList):
        if type(item) == type(dict()):
            for eachItem in itemList:
                if self.compareItemWithKey(attr, item, eachItem):
                    return eachItem
        else:
            for eachItem in itemList:
                if eachItem == item:
                    return eachItem
        return None

    def mergeConfig(self, config1, config2):
        for attr in config2:
            if not config1.has_key(attr):
                config1[attr] = config2[attr]
            else:
                if config2[attr]:
                    if type(config2[attr]) == type(list()):
                        newItemList = []
                        for item in config2[attr]:
                            matchedItem = self.findItemInList(attr, item, config1[attr])
                            if matchedItem:
                                if self.getChildMergeNeeded(attr, matchedItem):
                                    self.mergeConfig(matchedItem, item)
                            else:
                                newItemList.append(item)
                        config1[attr] = newItemList + config1[attr]
        return config1

    def getChildMergeNeeded(self,attr,childNode):
        if type(childNode) != type(dict()):
            return False
        keyType, itemKeys = self.findItemKeyByJsonKey(attr)
        if keyType:
            for childAttr in childNode:
                for eachKeyType in self.ITEM_KEYS:
                    if self.ITEM_KEYS[eachKeyType].has_key("parent") and keyType == self.ITEM_KEYS[eachKeyType]["parent"]:
                        if childAttr == self.ITEM_KEYS[eachKeyType]["jsonKey"]:
                            return self.ITEM_KEYS[eachKeyType].has_key("mergeNeeded") and self.ITEM_KEYS[eachKeyType]["mergeNeeded"]
        return False

    def backupFile(self, fileName):
        if os.path.exists(fileName):
            shutil.copyfile(fileName, fileName + '_ORIG_' + time.strftime('%Y%m%d%H%M%S'))

    def makeDir(self, directory):
        if not os.path.exists(directory):
            os.makedirs(directory)
            self.output("Directory not exists, make directory: " + directory)
    
    def insertPartners(self, partners):
        if partners is None or not len(partners):
            return
        partner = PartnersRestMgr.PartnersRestMgr()
        for p in partners:
            partner.handle(p["PROVIDERID"],p["NAME"], p["PARTNERTYPE"],p["PROVIDERID"],p["CONTENTCLASSNAME"],self.getIsDelete(p))

    def handle_sites(self, sites, is_override=False):
        if sites is None or not len(sites):
            return
        site = SitesRestMgr.SitesRestMgr(is_override)
        for s in sites:
            if is_override and SITE_FIELDS_TO_UPDATE in s:  # upgrade
                s = site.set_fields_in_update(s)
            if s:
                deleteSite = self.getIsDelete(s)
                site.handle(s[SITE_NAME], s[SITE_EXTERNALID], s[SITE_ACTIVE], s[SITE_DISTRIBUTION_OPTION],
                            s[SITE_METADATA_FORMAT], s[SITE_FILE_LOOKUP_KEYS], s[SITE_DIST_TEMPLATE_NAME],
                            s[SITE_ALERT_DELAY_PERIOD], s[SITE_TYPE], s[SITE_ASSOCIATE_RESOURCE], s[SITE_PARAMETERS],
                            s[SITE_PARTIAL_OFFER_DISTRIBUTION], s[SITE_PARTIAL_DEPENDS_ON_DISTRIBUTION],
                            s[SITE_DEPENDS_ON_SITE], s[SITE_MONITORED_RESOURCES], s[SITE_DISTRIBUTION_STATUS_PLUGIN], deleteSite)

    def insertSelectorKeys(self, selectorKeys):
        if selectorKeys is None or not len(selectorKeys):
            return
        selectorKey = SelectorKeyRestMgr.SelectorKeyRestMgr()
        for sk in selectorKeys:
            selectorKey.handle(sk["SELECTIONKEY"],sk["TEMPLATE"],self.getIsDelete(sk))

    def insertCustomFieldsGroups(self, cfgs):
        if cfgs is None or not len(cfgs):
            return
        customFieldsGroups = CustomFieldsGroups.CustomFieldsGroups()
        for cfg in cfgs:
            isDelete = self.getIsDelete(cfg)
            customFieldsGroups.handle(cfg["DISPLAY_NAME"],cfg["ASSET_PATH"],cfg["UUID"],isDelete)
            if not isDelete:
                self.insertCustomFields(cfg["DISPLAY_NAME"],cfg["ASSET_PATH"],cfg["FIELDS"])

    def insertCustomFields(self, groupName,assetPath,cfs):
        if cfs is None or not len(cfs):
            return
        customFields = CustomFields.CustomFields()
        for cf in cfs:
            customFields.handle(cf["NAME"],groupName,assetPath,cf["DATA_TYPE"],cf["JOB_PARAMETER"],cf["JOB_SCHEDULE_PARAMETER"],cf["DISPLAY_NAME"],cf["MULTIVALUE"],cf["FIELD_TYPE"],self.getIsDelete(cf))

    def insertResources(self, rs):
        if rs is None or not len(rs):
            return
        resMgr = ResourcesRestMgr.ResourcesRestMgr()
        for r in rs:
            # CMS2.5 has extra FUNCTIONALTYPE at end -> not enough values
            resMgr.handle(r["NAME"], r["RESOURCETYPENAME"], r["RESOURCEGROUPNAME"], r["CONNECTIONSTRING"],
                          r["MAXCONCURRENTUSERS"], 2, 2, r["HEARTBEATCONNECTIONSTRING"], r["HEARTBEATFREQUENCY"], 1, 1,
                          r["USERNAME"], '', self.getIsDelete(r))

    def updateResourceGroupsAllocation(self, rgsAllocation):
        if rgsAllocation is None or not len(rgsAllocation):
            return
        resourceGroupsRestMgr = ResourceGroupsRestMgr.ResourceGroupsRestMgr()
        for rg in rgsAllocation:
            resourceGroupsRestMgr.updateRGAllocation(rg["NAME"], rg["ISALLOCATABLE"])

    def insertAlerts(self, alerts):
        if alerts is None or not len(alerts):
            return

        if Alerts.isAlertFileExist():
            als = Alerts()
            als.insertAlerts(alerts, self)

    def handleMeSubsProfiles(self, meprofiles):
        if meprofiles is None or not len(meprofiles):
            return
        profile = MeSubsProfile.MeSubsProfile()
        for meProfile in meprofiles:

            if (not self.getIsDelete(meProfile)):
                profile.handle(meProfile["NAME"], meProfile["PLUGIN_NAME"], self.getIsDelete(meProfile))
                self.handleMeIdentifirerCriteria(meProfile["NAME"], meProfile["CRITERIA"])
                self.handleMeEnhancedField(meProfile["NAME"], meProfile["ENHANCEDFIELD"])
                self.handleMeSubsProfileParameter(meProfile["NAME"], meProfile["PARAMETER"])
            else:
                profile.handle(meProfile["NAME"], meProfile["PLUGIN_NAME"], True)

    def handleMeIdentifirerCriteria(self, meProfileName, criterias):
        if criterias is None or not len(criterias):
            return
        criteria = MeIdentifierCriteria.MeIdentifierCriteria()
        for c in criterias:
            criteria.handle(c["NAME"], meProfileName, c["MAPPING"], c["DATATYPE"], c["PATH"], c["ASSET_TYPE"], c["VALUE_FIELD_PATH"], self.getIsDelete(c))

    def handleMeEnhancedField(self, meProfileName, enhancedFields):
        if enhancedFields is None or not len(enhancedFields):
            return
        enhancedField = MeEnhancedField.MeEnhancedField()
        for ef in enhancedFields:
            enhancedField.handle(ef["NAME"], meProfileName, ef["MAPPING"], ef["DATATYPE"], ef["PATH"], self.getIsDelete(ef))

    def handleMeSubsProfileParameter(self, meProfileName, parameters):
        if parameters is None or not len(parameters):
            return
        parameter = MeSubsProfileParameter.MeSubsProfileParameter()
        for p in parameters:
            parameter.handle(p["NAME"], meProfileName, p["VALUE"], self.getIsDelete(p))

    # ===========================================================================
    # Export specify ruleSet to file
    # ===========================================================================
    def importRules(self, ruleSets):
        if ruleSets is None or not len(ruleSets):
            return

        rulesetsRestMgr = RulesetsRestMgr.RulesetsRestMgr()
        result = rulesetsRestMgr.queryRulesetsWithStatus()
        if not result[0]:
            print '[ERROR] Query rulesets status fail'
            sys.exit(1)

        enhancementRuleset = EnhancementRuleset.EnhancementRuleset()
        for rs in ruleSets:
            filePath = rs["FILENAME"]
            self.output("import ruleSets " + filePath)

            if enhancementRuleset.hasMetadataEnhancementRuleset(filePath):
                enhancementRuleset.replaceWithProfileId(filePath)

            rulesetsRestMgr.importRulesets(rs["FILENAME"], result[1])

    def sortRuleSet(self, ruleSetFiles):
        print "Sorting ruleset"
        cwd = os.path.dirname(os.path.realpath(__file__))
        inputfile = os.path.dirname(cwd) + '/components/BASE/ruleset_order_config.json'
        if not os.path.exists(inputfile):
            return False
        json_data = open(inputfile)
        ruleset_config = json.load(json_data)
        json_data.close()
        uuids = [r['uuid'] for r in ruleset_config['sorted_ruleset_uuids']]
        newlyImportedRuleSets = self.getUuidsFromXmls(ruleSetFiles)
        rulesetsRestMgr = RulesetsRestMgr.RulesetsRestMgr()
        return rulesetsRestMgr.sortByUuids(uuids, newlyImportedRuleSets)

    def deleteRuleSets(self, ruleSetFiles):
        if ruleSetFiles:
            rulesetsRestMgr = RulesetsRestMgr.RulesetsRestMgr()
            for ruleSetFile in ruleSetFiles:
                uuids = rulesetsRestMgr.getUuidsFromXml(self.getItemConfigValue(ruleSetFile, "FILENAME"))
                if not rulesetsRestMgr.deleteRulSetsByUuid(uuids):
                    print 'Failed to delete rule set: ', uuids

    def getUuidsFromXmls(self, ruleSetFiles):
        allUuids = []
        if ruleSetFiles:
            rulesetsRestMgr = RulesetsRestMgr.RulesetsRestMgr()
            for ruleSetFile in ruleSetFiles:
                uuids = rulesetsRestMgr.getUuidsFromXml(self.getItemConfigValue(ruleSetFile, "FILENAME"))
                allUuids.extend(uuids)
        return allUuids

    def disableProcessDefinitions(self, templates):
        if templates is None or not len(templates):
            return
        pds = ProcessDefinitions.ProcessDefinitions()
        for tpl in templates:
            pds.disable(tpl)

    def executeSqlInWorkflowDB(self, queries):
        if queries is None or not len(queries):
            return
        connection = CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().getWorkflowDatabaseConnection()
        for query in queries:
            try:
                queryStatement = query["QUERY"]
                if queryStatement.endswith(".sql") and os.path.exists(queryStatement):
                    with open(queryStatement, 'r') as f:
                        queryStatement = f.read()
                        print queryStatement
                        connection.cursor().execute(queryStatement)
                else:
                    print queryStatement
                    connection.cursor().execute(queryStatement)
                if query["COMMIT"] is not None and str(query["COMMIT"]).lower() == "true":
                    connection.commit()
            except Exception, e:
                print e
                connection.rollback()
        time.sleep(.1)
    
    @staticmethod
    def executeScripts(scripts):
        if scripts is None or not len(scripts):
            return
        for script in scripts:
            print "execute script:", script
            print os.popen("sh " + script, "r").read()

    def output(self, outputstr):
        """ Writes print statements to log as well as to screen """
        print outputstr

    def ip(self, hostname):
        return socket.gethostbyname(hostname)

    def getConfig(self, name):
        if self.config.has_key(name):
            return self.config[name]

    def wrapConfigWithFullAttributes(self,configItem, type):
        for attr in self.ITEM_KEYS[type]["keys"]:
            if not configItem.has_key(attr):
                configItem[attr] = None
        return configItem

    def wrapConfigListWithFullAttributes(self, configList, type):
        if configList is None:
            return
        for configItem in configList:
            self.wrapConfigWithFullAttributes(configItem, type)

    def wrapAllConfigWithFullAttributes(self):
        for itemKey in self.ITEM_KEYS:
            itemKeyObj = self.ITEM_KEYS[itemKey]
            if itemKeyObj.has_key("parent"):
                parentConfig = self.getConfig(self.ITEM_KEYS[itemKeyObj["parent"]]["jsonKey"])
                if parentConfig is not None:
                    for parentConfigItem in parentConfig:
                        if parentConfigItem.has_key(itemKeyObj["jsonKey"]):
                            self.wrapConfigListWithFullAttributes(parentConfigItem[itemKeyObj["jsonKey"]],itemKey)
            else:
                self.wrapConfigListWithFullAttributes(self.getConfig(itemKeyObj["jsonKey"]),itemKey)

    def getItemKeyArray(self, type):
        return self.ITEM_KEYS[type]["keys"]

    def getItemJsonKey(self, type):
        return self.ITEM_KEYS[type]["jsonKey"]

    def getItemUniqueKeyArray(self, type):
        return self.ITEM_KEYS[type]["uniqueKeys"]

    def buildServiceObjectsByName(self, serviceName):
        services = {
            'cms': CMSService(),
            'workflow': WorkflowService(),
            'filemanager': FilemanagerService(),
        }
        return services.get(serviceName, GenericService(serviceName))

    def stopServices(self, services):
        for serviceName in services:
            service = self.buildServiceObjectsByName(serviceName)
            service.stop()
            
        for serviceName in services:
            service = self.buildServiceObjectsByName(serviceName)
            if not service.waitForServiceDown():
                raise Exception('Failed to shut down service %s.' % serviceName)

    def startServices(self, services, waitForUp=True):
        for serviceName in services:
            service = self.buildServiceObjectsByName(serviceName)
            service.start()
            
        for serviceName in services:
            service = self.buildServiceObjectsByName(serviceName)
            if waitForUp and not service.waitForServiceUp():
                raise Exception('Failed to start service %s.' % serviceName)

    def restartServices(self, services, waitForUp=True):
        for serviceName in services:
            service = self.buildServiceObjectsByName(serviceName)
            service.restart()
            
        for serviceName in services:
            service = self.buildServiceObjectsByName(serviceName)
            if waitForUp and not service.waitForServiceUp():
                raise Exception('Failed to startup service %s.' % serviceName)

    # get list of file info objects for files of particular extensions
    def listDirectory(self, directory, fileExtList):
        fileList = [os.path.normcase(f)
                    for f in os.listdir(directory)]
        fileList = [os.path.join(directory, f)
                    for f in fileList
                    if os.path.splitext(f)[1] in fileExtList]
        return fileList

    def getItemConfigValue(self, item, name):
        if not item.has_key(name):
            return None
        else:
            return item[name]

    def getIsDelete(self, item):
        isDelete = self.getItemConfigValue(item, "IS_DELETE")
        return isDelete is not None and str(isDelete).lower() == "true"

    def getRaname(self, item):
        rename = self.getItemConfigValue(item, "RENAME")
        return rename

    def executeCommand(self, command):
        try:
            return os.popen(command, "r").read()
        except Exception:
            raise

    def checkIfDirs(self, path):
        return os.path.isdir(path)

    def checkIfExists(self, path):
        return os.path.exists(path)
